/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.sap.core.deploy.client.utils.DeployClientUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DeploymentContentAnalyzer {
    private String[] contentFolders;
    private File[] deploymentFiles;
    private String contentType;
    private long totalSize = 0L;
    private static Logger LOGGER = Logger.getLogger(DeploymentContentAnalyzer.class);
    public static final String LOCAL_UPDATE_SITE_CONTENT_TYPE = "application/zip";
    public static final String MIXED_CONTENT_TYPE = "application/zip; folder=wars_and_bundles";

    public DeploymentContentAnalyzer(String[] contentFolders) {
        this.contentFolders = contentFolders;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Folders and files, provided for deployment content anaysis:");
            String[] stringArray = contentFolders;
            int n = contentFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String contentFolder = stringArray[n2];
                LOGGER.debug((Object)contentFolder);
                ++n2;
            }
        }
    }

    public void analyze() throws IOException {
        LOGGER.debug((Object)"Starting analysis of provided deployment content...");
        Arrays.sort(this.contentFolders);
        File localUpdateSite = DeployClientUtils.detectLocalUpdateSiteIfAvailable(this.contentFolders);
        if (localUpdateSite != null) {
            this.deploymentFiles = new File[1];
            this.deploymentFiles[0] = localUpdateSite;
            this.contentType = LOCAL_UPDATE_SITE_CONTENT_TYPE;
        } else {
            this.deploymentFiles = DeployClientUtils.detectLocalWarFilesAndBundles(this.contentFolders);
            if (this.deploymentFiles.length > 0) {
                this.contentType = MIXED_CONTENT_TYPE;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Analysis of provided deployment content finished");
            LOGGER.debug((Object)("Determined content type: " + this.contentType));
            LOGGER.debug((Object)"Detected files for deployment:");
            File[] fileArray = this.deploymentFiles;
            int n = this.deploymentFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File deploymentFile = fileArray[n2];
                LOGGER.debug((Object)deploymentFile.getAbsoluteFile());
                ++n2;
            }
        }
    }

    public File[] getDeploymentFiles() {
        return this.deploymentFiles;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    private void calculateSize(File[] files) {
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("File for deploy " + file.getAbsolutePath() + " has estimated size of " + file.length() + " bytes"));
                    }
                    this.totalSize += file.length();
                }
                if (file.isDirectory()) {
                    this.calculateSize(file.listFiles());
                }
                ++n2;
            }
        }
    }

    public void calculateSize() {
        if (this.totalSize > 0L) {
            return;
        }
        LOGGER.debug((Object)"Starting calculation of total size of detected local deployment content");
        this.calculateSize(this.deploymentFiles);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total size of detected local deployment content is " + this.totalSize + " bytes"));
        }
    }
}

