/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.sap.core.deploy.client.utils.HttpClientFactoryException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class HttpClientFactory {
    public static String proxyHost = null;
    public static int proxyPort = -1;
    private static final Logger logger = Logger.getLogger((String)HttpClientFactory.class.getName());
    private static HttpClient client = null;
    private static KeyManager[] manager = null;

    private static HttpClient wrapClient(HttpClient baseClient, KeyManager[] keyManagers) throws NoSuchAlgorithmException, KeyManagementException {
        if (baseClient == null) {
            return null;
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(keyManagers, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx);
        ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = baseClient.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(baseClient.getParams(), sr), baseClient.getParams());
        ((DefaultHttpClient)client).setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(sr, ProxySelector.getDefault()){

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                HttpHost proxy = this.determineProxy(target, request, context);
                if (proxy != null) {
                    HttpClientFactory.setCredentialsProviderIfNeeded(target, (DefaultHttpClient)client);
                    return new HttpRoute(target, null, proxy, "https".equalsIgnoreCase(target.getSchemeName()));
                }
                return new HttpRoute(target, null, "https".equalsIgnoreCase(target.getSchemeName()));
            }
        });
        return client;
    }

    private static void setCredentialsProviderIfNeeded(HttpHost targetHost, DefaultHttpClient argClient) {
        String proxyUser = null;
        String proxyPassword = null;
        if ("http".equals(targetHost.getSchemeName())) {
            proxyUser = System.getProperty("http.proxyUser");
            proxyPassword = System.getProperty("http.proxyPassword");
        } else if ("https".equals(targetHost.getSchemeName())) {
            proxyUser = System.getProperty("https.proxyUser");
            proxyPassword = System.getProperty("https.proxyPassword");
        }
        if (proxyUser != null && !proxyUser.equals("") && proxyPassword != null) {
            CredentialsProvider credentialsProvider = ((DefaultHttpClient)client).getCredentialsProvider();
            if (credentialsProvider == null) {
                credentialsProvider = new BasicCredentialsProvider();
                argClient.setCredentialsProvider(credentialsProvider);
            }
            AuthScope authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort());
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            credentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
        }
    }

    private static void initKeyManagers(InputStream keystoreInputStream, String keystorePass, boolean reload) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        if (!reload && manager != null) {
            return;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(keystoreInputStream, keystorePass.toCharArray());
        keystoreInputStream.close();
        keyManagerFactory.init(keyStore, keystorePass.toCharArray());
        manager = keyManagerFactory.getKeyManagers();
    }

    public static HttpClient createDefaultHttpClient() {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        return defaultHttpClient;
    }

    public static HttpClient createSSLHttpClient(InputStream keystoreInputStream, String keystorePass, boolean reload) throws HttpClientFactoryException {
        try {
            if (keystoreInputStream != null) {
                HttpClientFactory.initKeyManagers(keystoreInputStream, keystorePass, reload);
                return HttpClientFactory.wrapClient(HttpClientFactory.createDefaultHttpClient(), manager);
            }
            return HttpClientFactory.wrapClient(HttpClientFactory.createDefaultHttpClient(), null);
        }
        catch (KeyManagementException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (UnrecoverableKeyException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (KeyStoreException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (CertificateException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (IOException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        return null;
    }

    public static HttpClient createSSLHttpClient() throws HttpClientFactoryException {
        try {
            return HttpClientFactory.wrapClient(HttpClientFactory.createDefaultHttpClient(), null);
        }
        catch (KeyManagementException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            HttpClientFactory.throwHttpClientFactoryException(e);
        }
        return null;
    }

    private static void throwHttpClientFactoryException(Exception e) throws HttpClientFactoryException {
        logger.error((Object)"An error occured while creating the SSL Http Client. See the causing exception for the reason for failure.", (Throwable)e);
        throw new HttpClientFactoryException("An error occured while creating the SSL Http Client. See the causing exception for the reason for failure.", e);
    }
}

