/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.sap.core.deploy.client.utils.NetworkUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class LogonUtils {
    public static void createLoginRequest(HttpClient sslClientWithCert, HttpContext localContext, String host, String alias) throws ClientProtocolException, IOException {
        if (!LogonUtils.isLoggedUser(localContext)) {
            String urlString = String.valueOf(host) + "/" + alias + "spaces" + "/";
            LogonUtils.createLoginRequest(sslClientWithCert, localContext, urlString);
        }
    }

    public static void createLoginRequest(HttpClient sslClientWithCert, HttpContext localContext, String urlString) throws ClientProtocolException, IOException {
        String result;
        HttpResponse response = null;
        try {
            HttpGet get = new HttpGet(urlString);
            response = sslClientWithCert.execute((HttpUriRequest)get, localContext);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Throwable throwable) {
            NetworkUtils.consumeEntity(response);
            throw throwable;
        }
        NetworkUtils.consumeEntity(response);
        if (!IDMResponse.isIDMResponse(result)) {
            return;
        }
        IDMResponse idmResponse = IDMResponse.parse(result);
        LogonUtils.postLoginInfo(idmResponse, sslClientWithCert, localContext);
    }

    public static boolean isLoggedUser(HttpContext localContext) {
        return localContext.getAttribute("http.user-token") != null;
    }

    private static void postLoginInfo(IDMResponse idmResponse, HttpClient sslClientWithCert, HttpContext localContext) throws ClientProtocolException, IOException {
        ArrayList<BasicNameValuePair> authFormParams = new ArrayList<BasicNameValuePair>();
        authFormParams.add(new BasicNameValuePair("SAMLResponse", idmResponse.getSamlResponse()));
        authFormParams.add(new BasicNameValuePair("RelayState", idmResponse.getRelayState()));
        HttpPost httpPost = new HttpPost(idmResponse.getPostURL());
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(authFormParams, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = null;
        try {
            response = sslClientWithCert.execute((HttpUriRequest)httpPost, localContext);
        }
        catch (Throwable throwable) {
            NetworkUtils.consumeEntity(response);
            throw throwable;
        }
        NetworkUtils.consumeEntity(response);
    }

    private static class IDMResponse {
        private static final String VALUE_SUFFIX = "\"";
        private static final String ACTION_PREFIX = "action=\"";
        private static final String RELAY_STATE_PREFIX = "name=\"RelayState\" value=\"";
        private static final String SAML_RESPONSE_PREFIX = "name=\"SAMLResponse\" value=\"";
        private String samlResponse;
        private String relayState;
        private String postURL;

        public static boolean isIDMResponse(String response) {
            return response.contains(SAML_RESPONSE_PREFIX);
        }

        public static IDMResponse parse(String response) {
            String samlResponse = IDMResponse.getValue(response, SAML_RESPONSE_PREFIX, VALUE_SUFFIX);
            String relayState = IDMResponse.getValue(response, RELAY_STATE_PREFIX, VALUE_SUFFIX);
            String postURL = IDMResponse.getValue(response, ACTION_PREFIX, VALUE_SUFFIX);
            return new IDMResponse(samlResponse, relayState, postURL);
        }

        private static String getValue(String string, String prefix, String suffix) {
            int startIndex = string.indexOf(prefix) + prefix.length();
            int endIndex = string.indexOf(suffix, startIndex);
            return string.substring(startIndex, endIndex);
        }

        IDMResponse(String samlResponse, String relayState, String postURL) {
            this.samlResponse = samlResponse;
            this.relayState = relayState;
            this.postURL = postURL;
        }

        public String getSamlResponse() {
            return this.samlResponse;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public String getPostURL() {
            return this.postURL;
        }
    }
}

