/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class NetworkUtils {
    private static final Logger LOGGER = Logger.getLogger(NetworkUtils.class);
    private static final NetworkUtils INSTANCE = new NetworkUtils();

    public static NetworkUtils getInstance() {
        return INSTANCE;
    }

    protected NetworkUtils() {
    }

    public HttpResponse executeRequestAndFollowRedirectNonStatic(HttpClient httpClient, HttpRequestBase httpRequest, int maxConnectionsIncrease, int connectionsPerRouteIncrease) throws IOException {
        return NetworkUtils.executeRequestAndFollowRedirect(httpClient, httpRequest, maxConnectionsIncrease, connectionsPerRouteIncrease);
    }

    public static HttpResponse executeRequestAndFollowRedirect(HttpClient httpClient, HttpRequestBase httpRequest, int maxConnectionsIncrease, int connectionsPerRouteIncrease) throws IOException {
        return NetworkUtils.executeRequestAndFollowRedirect(httpClient, httpRequest, null, maxConnectionsIncrease, connectionsPerRouteIncrease);
    }

    public HttpResponse executeRequestAndFollowRedirectNonStatic(HttpClient httpClient, HttpRequestBase httpRequest, String protocolVersion, int maxConnectionsIncrease, int connectionsPerRouteIncrease) throws IOException {
        return NetworkUtils.executeRequestAndFollowRedirect(httpClient, httpRequest, protocolVersion, maxConnectionsIncrease, connectionsPerRouteIncrease);
    }

    public static HttpResponse executeRequestAndFollowRedirect(HttpClient httpClient, HttpRequestBase httpRequest, String protocolVersion, int maxConnectionsIncrease, int connectionsPerRouteIncrease) throws IOException {
        HttpResponse response;
        ThreadSafeClientConnManager cm = null;
        int maxTotalConnectionsOldValue = 0;
        int maxConnectionsPerRouteOldValue = 0;
        if (maxConnectionsIncrease > 0 && connectionsPerRouteIncrease > 0) {
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            if (ccm instanceof ThreadSafeClientConnManager) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Reconfiguring HTTP client connection manager to use for deploy with multiple connections");
                }
                cm = (ThreadSafeClientConnManager)ccm;
                maxTotalConnectionsOldValue = NetworkUtils.increaseMaxTotal(cm, maxConnectionsIncrease);
                maxConnectionsPerRouteOldValue = NetworkUtils.increaseDefaultMaxPerRoute(cm, connectionsPerRouteIncrease);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Cannot increase maximum number of connections since connection manager used is not an instance of ThreadSafeClientConnManager. You may experience problems with multi-thread operations");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"No increase in maximum number of connections requested. You may experience problems with multi-thread operations");
        }
        if (protocolVersion != null) {
            NetworkUtils.setAcceptHeader(httpRequest, protocolVersion);
        }
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
        }
        finally {
            if (cm != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Restoring original settings of HTTP client connection manager: maxTotal: " + maxTotalConnectionsOldValue + ", maxPerRoute: " + maxConnectionsPerRouteOldValue));
                }
                cm.closeExpiredConnections();
                NetworkUtils.setMaxTotal(cm, maxTotalConnectionsOldValue);
                NetworkUtils.setDefaultMaxPerRoute(cm, maxConnectionsPerRouteOldValue);
            }
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 302) {
            Header locationHeader;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Http request to URI [" + httpRequest.getURI() + "] requires redirect. The status code is " + status));
            }
            if ((locationHeader = response.getFirstHeader("Location")) != null) {
                String redirectLocation = locationHeader.getValue();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("The redirect location is [" + redirectLocation + "]"));
                }
                httpRequest.setURI(URI.create(redirectLocation));
                return httpClient.execute((HttpUriRequest)httpRequest);
            }
            throw new ClientProtocolException("Http request to URL [" + httpRequest.getURI() + "] requires redirect, but the response doesn`t specify URL for redirection");
        }
        return response;
    }

    public static HttpResponse executeRequestAndFollowRedirect(HttpClient httpClient, HttpRequestBase httpRequest, String protocolVersion) throws IOException {
        return NetworkUtils.executeRequestAndFollowRedirect(httpClient, httpRequest, protocolVersion, 0, 0);
    }

    private static void setAcceptHeader(HttpRequestBase httpRequest, String protocolVersion) throws IllegalStateException, IOException {
        HttpEntity enclosedEntity;
        String acceptHeader = "version=" + protocolVersion;
        if (httpRequest instanceof HttpEntityEnclosingRequestBase && (enclosedEntity = ((HttpEntityEnclosingRequestBase)httpRequest).getEntity()) != null && enclosedEntity.getContentType() != null) {
            Header contentType = enclosedEntity.getContentType();
            String contentValue = contentType.getValue();
            acceptHeader = String.valueOf(contentValue) + ";" + acceptHeader;
        }
        httpRequest.setHeader((Header)new BasicHeader("Accept", acceptHeader));
    }

    public static synchronized int setMaxTotal(ThreadSafeClientConnManager cm, int newValue) {
        int oldValue = cm.getMaxTotal();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Previous value of MaxTotal connections is " + oldValue + ". Setting new value: " + newValue));
        }
        cm.setMaxTotal(newValue);
        return oldValue;
    }

    public static synchronized int setDefaultMaxPerRoute(ThreadSafeClientConnManager cm, int newValue) {
        int oldValue = cm.getDefaultMaxPerRoute();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Previous value of MaxPerRoute connections is " + oldValue + ". Setting new value: " + newValue));
        }
        cm.setDefaultMaxPerRoute(newValue);
        return oldValue;
    }

    public static synchronized int increaseMaxTotal(ThreadSafeClientConnManager cm, int increase) {
        int oldValue = cm.getMaxTotal();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Previous value of MaxTotal connections is " + oldValue + ". Setting new value: " + oldValue + increase));
        }
        cm.setMaxTotal(oldValue + increase);
        return oldValue;
    }

    public static synchronized int increaseDefaultMaxPerRoute(ThreadSafeClientConnManager cm, int increase) {
        int oldValue = cm.getDefaultMaxPerRoute();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Previous value of MaxPerRoute connections is " + oldValue + ". Setting new value: " + oldValue + increase));
        }
        cm.setDefaultMaxPerRoute(oldValue + increase);
        return oldValue;
    }

    public static boolean consumeEntity(HttpResponse response) {
        if (response == null) {
            return false;
        }
        HttpEntity entity = response.getEntity();
        return NetworkUtils.consumeEntity(entity);
    }

    public static boolean consumeEntity(HttpEntity entity) {
        try {
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Cannot consume entity ", (Throwable)e);
            return false;
        }
        return true;
    }
}

