/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.sap.core.deploy.client.impl.requests.HttpPatch;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public class RequestPreparationFactory {
    private static final RequestPreparationFactory INSTANCE = new RequestPreparationFactory();

    public static RequestPreparationFactory getInstance() {
        return INSTANCE;
    }

    private RequestPreparationFactory() {
    }

    public HttpRequestBase prepareRequest(String methodName, String url, HttpEntity httpEntity, Header ... headers) {
        HttpRequestBase httpRequest = this.getHttpRequest(methodName, url);
        this.setHeaders(httpRequest, headers);
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(httpEntity);
        }
        return httpRequest;
    }

    protected void setHeaders(HttpRequestBase httpRequest, Header ... headers) {
        if (headers != null) {
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                httpRequest.setHeader(header);
                ++n2;
            }
        }
    }

    private HttpRequestBase getHttpRequest(String methodName, String url) {
        if (url == null) {
            throw new IllegalStateException("Request url cannot be null.");
        }
        if ("GET".equals(methodName)) {
            return new HttpGet(url);
        }
        if ("POST".equals(methodName)) {
            return new HttpPost(url);
        }
        if ("PUT".equals(methodName)) {
            return new HttpPut(url);
        }
        if ("DELETE".equals(methodName)) {
            return new HttpDelete(url);
        }
        if ("PATCH".equals(methodName)) {
            return new HttpPatch(url);
        }
        throw new IllegalStateException("Illegal request method name: " + methodName);
    }
}

