/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.impl.JSONParser;
import com.sap.core.deploy.client.publicrest.impl.ReadDetailedApplicationStateClient;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.StatusResponse;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.PropertiesConstants;
import com.sap.core.deploy.commons.rest.entity.RuntimeArgument;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.ResponseEntity;
import com.sap.core.deploy.commons.rest.entity.response.StatusResponseMetadataWithComponent;
import com.sap.core.deploy.commons.status.LBStatus;
import com.sap.core.utils.security.logon.LogonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ResultBuilder {
    static Logger logger = Logger.getLogger(ResultBuilder.class);
    static final String LOG_MEESAGE_PATTERN = "The message returned from server is: %s\nThe message id is: [%s]";
    public static final int SC_UNSUCCESSFULL_OPERATION = 580;
    public static final String DEPLOY_HEADER = "X-DeployService";
    public static final String SERVER_HEADER = "Server";
    public static final String DOMAIN_HEADER = "X-DomainController";
    public static final String AUTHENTICATION_EXCEPTION = "Authentication error. Check if you have provided correct credentials.";
    public static final String FORBIDDEN_EXCEPTION = "Access to %s is not allowed from your network. Contact SAP Cloud Platform for help";
    public static final String UNKNOWN_HOST_MESSAGE = "Unknown SAP Cloud Platform host was provided. Check whether the host is correctly spelled.";
    public static final String SERVICE_UNAVAILABLE_MESSAGE = "The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.";
    public static final String WEB_SERVER_PROBLEM = "The Web Server may be down, too busy, or experiencing other problems preventing it from responding to requests. Try again at a later time";
    public static final String NOT_RECOGNIZED_RESPONSE = "Not recognized response.\n    The host name of the configured server is not a valid entry point to the SAP Cloud Platform, or, the request did not reach the server.";
    public static final String NO_MESSAGE_FROM_SERVER = "There is no message in the response returned from server";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String SPECIFY_APPLICATION_NAME = "Please specify application name.";
    public static final String SPECIFY_PROCESS_ID = "Application process ID must not be null.";
    public static final String NO_HOST_SPECIFIED = "No host specified";
    public static final String RESULT_BUILDING_ERROR = "Building of result for operation %s failed.";
    public static final String UNABLE_TO_PARSE_JSON_RESPONSE = "Unable to parse json response from server.";
    public static final String INVALID_PARAMETERS = "Invalid parameters.";
    public static final String NO_MESSAGE_IN_SERVER_RESPONSE = "There is no message in the response returned from server.";
    public static final String NO_URL_FOR_STARTED_COMPONENT = "Component is started but the URL for access cannot be obtained.";
    public static final String CSRF_TOKEN_COULD_NOT_BE_INITIALIZED = "Csrf token could not be initialized with first fetch request";
    public static final String INTERNAL_SERVER_ERROR_MSG = "Internal server error occurred.";
    public static final String UNEXPECTED_RESPONSE = "Unexpected response from server.";
    public static final String RESPONSE_BODY_CANNOT_BE_PARSED = "Unexpected response from server. Error parsing response body.";
    public static final String INVALID_USER_MSG = "Authorization failed. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n";
    public static final String CLIENT_ERROR = "Operation cannot be executed. Check client logs for details";
    private static final String STATUS = "status";
    private static final String LB_STATUS = "lbStatus";
    private static final String MAINTENANCE_APPLICATION = "maintenanceApplication";
    private static final String DOWNTIME_APPLICATION = "downtimeApplication";
    private static final String MESSAGE = "message";
    private static final String EXCEPTIONS = "exceptions";
    private static final String URL_PREFIX = "url";
    private static final String URL_SUFFIX = "domain";
    private static final String URLS_KEY = "urls";
    private static final String ALIASES_KEY = "aliases";
    private static final String RUNTIME_KEY = "runtime";
    private static final String APPLICATION_PROCESSES_KEY = "applicationProcesses";
    private static final String APPLICATION_ID_KEY = "processId";
    private static final String TEXT = "text";
    private static final String ID = "id";
    public static final String DESCRIPTION = "description";

    public static DeployResult processResponse(int code, int status, HttpResponse response, String operationName, String restRequest) {
        return ResultBuilder.processResponse(code, status, response, operationName, restRequest, null);
    }

    public static DeployResult processResponse(int code, int status, HttpResponse response, String operationName, String restRequest, String responseBody) {
        String serverHeaderStr;
        Header responseContentType;
        block15: {
            responseContentType = response.getFirstHeader("Content-type");
            Header deployHeader = response.getFirstHeader(DEPLOY_HEADER);
            String deployHeaderStr = deployHeader == null ? null : String.valueOf(deployHeader.getName()) + ": " + deployHeader.getValue();
            Header serverHeader = response.getFirstHeader(SERVER_HEADER);
            String string = serverHeaderStr = serverHeader == null ? null : String.valueOf(serverHeader.getName()) + ": " + serverHeader.getValue();
            if (logger.isDebugEnabled()) {
                String additionalHeaderStr = "Deploy service header: " + deployHeaderStr + "\nServer header: " + serverHeaderStr;
                logger.debug((Object)("Executed [" + operationName + "] operation with REST request: " + restRequest + "\nServer returned: " + status + "\n" + additionalHeaderStr));
            }
            HttpEntity entity = response.getEntity();
            try {
                if (responseBody != null) break block15;
                try {
                    responseBody = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    DeployResult deployResult = new DeployResult(1, e.getMessage(), e.toString());
                    NetworkUtils.consumeEntity(entity);
                    return deployResult;
                }
            }
            finally {
                NetworkUtils.consumeEntity(entity);
            }
        }
        if (responseContentType != null && responseContentType.getValue().startsWith(CONTENT_TYPE_JSON)) {
            try {
                if (responseBody == null || responseBody.trim().equals("")) {
                    if (status == 200) {
                        return new DeployResult(0, null, null);
                    }
                    return new DeployResult(1, NO_MESSAGE_FROM_SERVER, null);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The body returned from the server is: \n" + responseBody));
                }
                JsonObject jsonResponse = JSONParser.parseJsonResponse(responseBody);
                String message = JSONParser.getStringValue(jsonResponse, TEXT);
                String messageId = JSONParser.getStringValue(jsonResponse, ID);
                if (message == null || message.trim().equals("")) {
                    message = status != 200 ? NO_MESSAGE_FROM_SERVER : null;
                }
                ResultBuilder.logMessageDetails(message, messageId);
                return new DeployResult(code, message, null);
            }
            catch (SAXException e) {
                return new DeployResult(code, "Unable to parse response from server.", e.toString());
            }
        }
        if (status == 405) {
            return new DeployResult(code, "Authentication exception. Check if you have provided correct credentials.", null);
        }
        if (responseBody.contains(WEB_SERVER_PROBLEM)) {
            return new DeployResult(code, WEB_SERVER_PROBLEM, null);
        }
        return new DeployResult(code, NOT_RECOGNIZED_RESPONSE, "\nServer header: " + serverHeaderStr + "\n" + "The body of the message is: \n" + responseBody);
    }

    public static DeployResult buildDeployResult(HttpResponse response, String operationName, String restRequest) {
        int status = response.getStatusLine().getStatusCode();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Server returned code " + status));
        }
        try {
            if (ResultBuilder.isOrchestratorEndpoint(response)) {
                switch (status) {
                    case 200: {
                        if (response.getEntity() == null) {
                            DeployResult deployResult = new DeployResult(0, null, null);
                            return deployResult;
                        }
                        DeployResult deployResult = ResultBuilder.processResponse(0, status, response, operationName, restRequest);
                        return deployResult;
                    }
                    case 202: {
                        if (!NetworkUtils.consumeEntity(response)) {
                            DeployResult deployResult = ResultBuilder.processResponse(1, status, response, operationName, restRequest);
                            return deployResult;
                        }
                        return null;
                    }
                    case 580: {
                        DeployResult deployResult = ResultBuilder.processResponse(3, status, response, operationName, restRequest);
                        return deployResult;
                    }
                    case 400: {
                        DeployResult deployResult = ResultBuilder.processResponse(2, status, response, operationName, restRequest);
                        return deployResult;
                    }
                    case 500: {
                        DeployResult deployResult = ResultBuilder.processResponse(3, status, response, operationName, restRequest);
                        return deployResult;
                    }
                    case 401: {
                        DeployResult deployResult = new DeployResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
                        return deployResult;
                    }
                    case 409: {
                        DeployResult deployResult = ResultBuilder.processResponse(6, status, response, operationName, restRequest);
                        return deployResult;
                    }
                }
                DeployResult deployResult = ResultBuilder.processResponse(1, status, response, operationName, restRequest);
                return deployResult;
            }
            switch (status) {
                case 401: {
                    DeployResult deployResult = new DeployResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
                    return deployResult;
                }
                case 503: {
                    DeployResult deployResult = new DeployResult(3, SERVICE_UNAVAILABLE_MESSAGE, null);
                    return deployResult;
                }
            }
            DeployResult deployResult = new DeployResult(3, UNKNOWN_HOST_MESSAGE, null);
            return deployResult;
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    public static DeployResult buildDeployPollResult(HttpResponse response, String restRequest) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status poll returned code " + statusCode));
        }
        try {
            switch (statusCode) {
                case 200: {
                    Header statusHeader = response.getFirstHeader("X-DeployStatus");
                    if (statusHeader == null) {
                        DeployResult deployResult = new DeployResult(3, "Missing 'X-DeployStatus' header in server response!", null);
                        return deployResult;
                    }
                    String status = statusHeader.getValue();
                    HttpEntity responseEntity = response.getEntity();
                    String jsonBody = "";
                    try {
                        jsonBody = EntityUtils.toString((HttpEntity)responseEntity);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Deploy operation status (header): " + status));
                            logger.debug((Object)("Deploy operation status (json body): " + jsonBody));
                            StatusResponse statusResponse = (StatusResponse)new Gson().fromJson(jsonBody, StatusResponse.class);
                            logger.debug((Object)("Deploy operation status (deserialized): " + statusResponse.toString()));
                        }
                    }
                    catch (Exception e) {
                        NetworkUtils.consumeEntity(responseEntity);
                        DeployResult deployResult = new DeployResult(1, "Problem parsing json response from server!", ResultBuilder.getStackTrace(e));
                        NetworkUtils.consumeEntity(response);
                        return deployResult;
                    }
                    if ("SUCCESSFUL".equals(status)) {
                        if (responseEntity != null) {
                            DeployResult deployResult = ResultBuilder.processResponse(0, statusCode, response, "deploy", restRequest, jsonBody);
                            return deployResult;
                        }
                        DeployResult deployResult = new DeployResult(0, null, null);
                        return deployResult;
                    }
                    if ("FAILED".equals(status)) {
                        DeployResult deployResult = ResultBuilder.processResponse(4, statusCode, response, "deploy", restRequest, jsonBody);
                        return deployResult;
                    }
                    if ("RUNNING".equals(status)) {
                        NetworkUtils.consumeEntity(responseEntity);
                        return null;
                    }
                    break;
                }
                case 404: {
                    NetworkUtils.consumeEntity(response);
                    DeployResult deployResult = new DeployResult(1, "Deploy operation not existing or expired!", null);
                    return deployResult;
                }
                default: {
                    break;
                }
            }
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
        return new DeployResult(1, "Unexpected response from server. Server returned code " + statusCode + " while polling for status!", null);
    }

    public static LifecycleResult buildLifecycleResult(HttpResponse response, String operationName, String restRequest, String host, boolean isStart) {
        int status = response.getStatusLine().getStatusCode();
        if (!ResultBuilder.isOrchestratorEndpoint(response)) {
            NetworkUtils.consumeEntity(response);
            switch (status) {
                case 401: {
                    return new LifecycleResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                }
                case 503: {
                    return new LifecycleResult(3, SERVICE_UNAVAILABLE_MESSAGE);
                }
            }
            logger.warn((Object)"Missing header [X-DomainController] in server response. The check will be skipped.");
            return new LifecycleResult(3, UNKNOWN_HOST_MESSAGE);
        }
        String message = null;
        HttpEntity entity = response.getEntity();
        try {
            try {
                if (entity != null) {
                    message = EntityUtils.toString((HttpEntity)entity);
                }
            }
            catch (IOException e) {
                String errorMsg = "Building of result for operation " + operationName + " failed.";
                logger.error((Object)errorMsg, (Throwable)e);
                LifecycleResult lifecycleResult = ResultBuilder.buildLifecycleResult(1, errorMsg);
                NetworkUtils.consumeEntity(entity);
                return lifecycleResult;
            }
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
        switch (status) {
            case 200: {
                return ResultBuilder.buildLifecycleResult(0, message);
            }
            case 202: {
                return ResultBuilder.buildLifecycleResult(0, message);
            }
            case 404: {
                if (isStart) {
                    return ResultBuilder.buildLifecycleResult(4, message);
                }
                return ResultBuilder.buildLifecycleResult(5, message);
            }
            case 400: {
                return new LifecycleResult(2, "Invalid parameters. ");
            }
            case 500: {
                if (message != null) {
                    return ResultBuilder.buildLifecycleResult(3, message);
                }
                return new LifecycleResult(3, "Internal server error: " + status);
            }
            case 403: {
                if (isStart) {
                    return ResultBuilder.buildLifecycleResult(4, message);
                }
                return ResultBuilder.buildLifecycleResult(5, message);
            }
            case 405: {
                return new LifecycleResult(3, AUTHENTICATION_EXCEPTION);
            }
            case 401: {
                return new LifecycleResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
            case 409: {
                return ResultBuilder.buildLifecycleResult(6, message);
            }
        }
        if (isStart) {
            return ResultBuilder.buildLifecycleResult(4, message);
        }
        return ResultBuilder.buildLifecycleResult(5, message);
    }

    public static LifecycleResult buildLifecycleResult(int code, String jsonString) {
        try {
            if (jsonString == null || "".equals(jsonString.trim())) {
                return new LifecycleResult(code, NO_MESSAGE_IN_SERVER_RESPONSE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The body returned from the server is in json format: \n" + jsonString));
            }
            JsonObject jsonResponse = JSONParser.parseJsonResponse(jsonString);
            String message = JSONParser.getStringValue(jsonResponse, MESSAGE);
            String status = JSONParser.getStringValue(jsonResponse, STATUS);
            LifecycleResult lifecycleResult = new LifecycleResult(code, Status.valueOf(status), message, null);
            if (jsonResponse.has(LB_STATUS)) {
                String lbStatusStr = JSONParser.getStringValue(jsonResponse, LB_STATUS);
                LBStatus lbStatus = LBStatus.fromString((String)lbStatusStr);
                lifecycleResult.setLBStatus(lbStatus);
                if (lbStatus == LBStatus.IN_MAINTENANCE) {
                    String maintenanceApplication = JSONParser.getStringValue(jsonResponse, MAINTENANCE_APPLICATION);
                    lifecycleResult.setMaintenanceApplication(maintenanceApplication);
                }
            }
            if (jsonResponse.has(DOWNTIME_APPLICATION)) {
                String downtimeApplication = JSONParser.getStringValue(jsonResponse, DOWNTIME_APPLICATION);
                lifecycleResult.setDowntimeApplication(downtimeApplication);
            }
            return lifecycleResult;
        }
        catch (SAXException e) {
            return new LifecycleResult(code, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString());
        }
    }

    public static StatusResult buildStatusResult(HttpResponse response, String applicationProcessId, String tenantId, String host, String componentId, String applianceId, String spaceId) {
        int status = response.getStatusLine().getStatusCode();
        if (!ResultBuilder.isOrchestratorEndpoint(response)) {
            return ResultBuilder.buildStatusResultForNonOrchestratorHost(response, status);
        }
        if (status == 200) {
            return ResultBuilder.buildStatusResult(0, response, host, componentId, applianceId, spaceId);
        }
        try {
            switch (status) {
                case 404: {
                    StatusResult statusResult = new StatusResult(4, Status.NOT_FOUND, ResultBuilder.getErrorMessageForHttpStatusNotFound(response, applicationProcessId));
                    return statusResult;
                }
                case 403: {
                    StatusResult statusResult = new StatusResult(5, Status.STOPPED, "Component is stopped");
                    return statusResult;
                }
                case 400: {
                    StatusResult statusResult = new StatusResult(2, "Invalid parameters. ");
                    return statusResult;
                }
                case 500: {
                    StatusResult statusResult = new StatusResult(3, "Internal server error: " + status);
                    return statusResult;
                }
                case 401: {
                    StatusResult statusResult = new StatusResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                    return statusResult;
                }
            }
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
        return new StatusResult(1, "Unknown response code: " + status);
    }

    public static String getErrorMessageForHttpStatusNotFound(HttpResponse response, String applicationProcessId) {
        String message = null;
        if (applicationProcessId != null) {
            message = "Application process not found\n";
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
                StringBuilder out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                message = String.valueOf(message) + out.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            message = "Component not found";
        }
        return message;
    }

    public static StatusResult buildStatusResultForNonOrchestratorHost(HttpResponse response, int status) {
        NetworkUtils.consumeEntity(response);
        switch (status) {
            case 401: {
                return new StatusResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
            case 503: {
                return new StatusResult(3, SERVICE_UNAVAILABLE_MESSAGE);
            }
        }
        logger.warn((Object)"Missing header [X-DomainController] in server response. The check will be skipped.");
        return new StatusResult(3, UNKNOWN_HOST_MESSAGE);
    }

    public static StatusResult buildStatusResult(int code, HttpResponse response, String host, String componentName, String appliance, String account) {
        ResultBuilder.logHeadersFromResponse(response);
        HttpEntity entity = response.getEntity();
        try {
            String jsonString = EntityUtils.toString((HttpEntity)entity);
            StatusResult statusResult = ResultBuilder.buildStatusResult(code, jsonString, host, componentName, appliance, account, null);
            return statusResult;
        }
        catch (IOException e) {
            logger.error((Object)"Error building status result", (Throwable)e);
            StatusResult statusResult = new StatusResult(1, Status.UNKNOWN, e.getMessage(), e.toString(), null, null, null);
            return statusResult;
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
    }

    private static StatusResult buildStatusResult(int code, String jsonString, String host, String componentName, String appliance, String account, String applicationState) {
        try {
            if (jsonString == null || "".equals(jsonString.trim())) {
                return new StatusResult(code, NO_MESSAGE_IN_SERVER_RESPONSE);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The body returned from the server is in json format: \n" + jsonString));
            }
            JsonObject jsonResponse = JSONParser.parseJsonResponse(jsonString);
            if (applicationState == null) {
                applicationState = JSONParser.getStringValue(jsonResponse, STATUS);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + applicationState + " status of" + (componentName != null ? " component [" + componentName + "] on" : "") + (appliance != null ? " appliance [" + appliance + "]" : "") + " and  host [" + host + "]."));
            }
            Status status = ResultBuilder.determineStatus(applicationState, jsonResponse, account, appliance, componentName);
            int statusCode = ResultBuilder.determineCode(code, status);
            Map<String, String> runtime = ResultBuilder.extractRuntimeFromJson(jsonResponse);
            String recommendedUrl = null;
            String[] urls = new String[]{};
            String[] aliases = new String[]{};
            if (status == Status.STARTED) {
                String urlPrefix = JSONParser.getStringValue(jsonResponse, URL_PREFIX);
                String urlSuffix = JSONParser.getStringValue(jsonResponse, URL_SUFFIX);
                if (urlPrefix != null && !urlPrefix.isEmpty()) {
                    if (urlSuffix != null && !urlSuffix.isEmpty()) {
                        urls = ResultBuilder.getStringArrayWithKeyFromJson(jsonResponse, URLS_KEY);
                        aliases = ResultBuilder.getStringArrayWithKeyFromJson(jsonResponse, ALIASES_KEY);
                        recommendedUrl = "https://" + urlPrefix + "." + urlSuffix;
                    } else {
                        recommendedUrl = ResultBuilder.getShortUrlFormat(host, urlPrefix);
                    }
                } else if (componentName != null) {
                    return new StatusResult(3, status, "Component is started but the URL for access cannot be obtained", null, null, null, null);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Recommended URL calculated as: " + recommendedUrl));
                    logger.debug((Object)("Available URLs calculated as: " + Arrays.asList(urls)));
                    logger.debug((Object)("Available aliases calculated as: " + Arrays.asList(aliases)));
                }
            }
            StatusResult statusResult = new StatusResult(statusCode, status, null, ResultBuilder.extractStackTracesFromJson(jsonResponse), recommendedUrl, urls, aliases, runtime);
            ResultBuilder.configureStatusResultWithLBStatus(jsonResponse, statusResult);
            ResultBuilder.configureStatusResultWithDowntimeApplication(jsonResponse, statusResult);
            ResultBuilder.configureStatusResultWithApplicationProcess(jsonResponse, statusResult);
            return statusResult;
        }
        catch (SAXException e) {
            logger.error((Object)("Unable to parse json response from server. Json response is: [" + jsonString + "]"));
            return new StatusResult(1, Status.UNKNOWN, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString(), null, null, null);
        }
    }

    public static void configureStatusResultWithApplicationProcess(JsonObject jsonResponse, StatusResult statusResult) {
        if (jsonResponse.has(APPLICATION_PROCESSES_KEY)) {
            JsonArray jsonApplicationProcesses = jsonResponse.getAsJsonArray(APPLICATION_PROCESSES_KEY);
            ApplicationProcessResource[] applicationProcesses = (ApplicationProcessResource[])new Gson().fromJson((JsonElement)jsonApplicationProcesses, ApplicationProcessResource[].class);
            statusResult.setApplicationProcesses(applicationProcesses);
        } else if (jsonResponse.has(APPLICATION_ID_KEY)) {
            ApplicationProcessResource applicationProcess = (ApplicationProcessResource)new Gson().fromJson((JsonElement)jsonResponse, ApplicationProcessResource.class);
            statusResult.setApplicationProcesses(new ApplicationProcessResource[]{applicationProcess});
        }
    }

    public static void configureStatusResultWithDowntimeApplication(JsonObject jsonResponse, StatusResult statusResult) {
        if (jsonResponse.has(DOWNTIME_APPLICATION)) {
            String downtimeApplication = JSONParser.getStringValue(jsonResponse, DOWNTIME_APPLICATION);
            statusResult.setDowntimeApplication(downtimeApplication);
        }
    }

    public static void configureStatusResultWithLBStatus(JsonObject jsonResponse, StatusResult statusResult) {
        String lbStatusStr;
        LBStatus lbStatus;
        if (jsonResponse.has(LB_STATUS) && (lbStatus = LBStatus.fromString((String)(lbStatusStr = JSONParser.getStringValue(jsonResponse, LB_STATUS)))) == LBStatus.IN_MAINTENANCE) {
            String maintenanceApplication = JSONParser.getStringValue(jsonResponse, MAINTENANCE_APPLICATION);
            statusResult.setLBStatus(lbStatus);
            statusResult.setMaintenanceApplication(maintenanceApplication);
        }
    }

    public static String extractStackTracesFromJson(JsonObject jsonResponse) {
        String excStackTracesStr = null;
        JsonElement exceptionsText = jsonResponse.get(EXCEPTIONS);
        if (exceptionsText != null) {
            if (Map.class.isInstance(exceptionsText)) {
                excStackTracesStr = ((Map)exceptionsText).values().toString();
            } else if (exceptionsText.toString().length() > 0 && logger.isDebugEnabled()) {
                logger.debug((Object)("Unexcepted type for exceptions value in json response - " + exceptionsText.getClass().getName() + ";\r\n" + "value is: " + exceptionsText));
                excStackTracesStr = exceptionsText.toString();
            }
        }
        return excStackTracesStr;
    }

    public static String getShortUrlFormat(String host, String urlPrefix) {
        String recommendedUrl = host.indexOf("://orchestrator") > 0 ? "https://" + urlPrefix + "." + host.substring(host.indexOf(".") + 1) : host.replace("://", "://" + urlPrefix + ".");
        return recommendedUrl;
    }

    private static String[] getStringArrayWithKeyFromJson(JsonObject jsonResponse, String key) {
        Gson gson = new Gson();
        String extracted = JSONParser.getStringValue(jsonResponse, key);
        if (extracted != null && !extracted.isEmpty()) {
            return (String[])gson.fromJson(extracted, String[].class);
        }
        return null;
    }

    public static Map<String, String> extractRuntimeFromJson(JsonObject jsonResponse) {
        Map<String, String> runtime = new HashMap<String, String>(0);
        JsonObject deployRuntime = JSONParser.getJsonObject(jsonResponse, RUNTIME_KEY);
        if (deployRuntime != null) {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            runtime = (Map)gson.fromJson(deployRuntime.toString(), type);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Available runtime meta data: " + ((Object)runtime).toString()));
        }
        return runtime;
    }

    public static void logHeadersFromResponse(HttpResponse response) {
        String serverHeaderStr;
        Header deployHeader = response.getFirstHeader(DEPLOY_HEADER);
        String deployHeaderStr = deployHeader == null ? null : String.valueOf(deployHeader.getName()) + ": " + deployHeader.getValue();
        Header serverHeader = response.getFirstHeader(SERVER_HEADER);
        String string = serverHeaderStr = serverHeader == null ? null : String.valueOf(serverHeader.getName()) + ": " + serverHeader.getValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received response with headers - Deploy service header: " + deployHeaderStr + "; Server header: " + serverHeaderStr));
        }
    }

    public static Status determineStatus(String statusStr, JsonObject jsonResponse, String account, String appliance, String componentName) {
        Status status;
        try {
            status = Status.valueOf(statusStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Received status response [%s] for [%s/%s/%s] does not contain valid status", jsonResponse, account, appliance, componentName), e);
        }
        return status;
    }

    private static int determineCode(int code, Status status) {
        if (code == 0 && ResultBuilder.isAcceptedStatus(status)) {
            return 0;
        }
        return code;
    }

    private static boolean isAcceptedStatus(Status status) {
        switch (status) {
            case STARTING: {
                return true;
            }
            case STARTED: {
                return true;
            }
            case STOPPING: {
                return true;
            }
            case STOPPED: {
                return true;
            }
        }
        return false;
    }

    public static RepositoryResult buildRepositoryResult(HttpResponse response, String classifier) {
        JsonObject jsonResponse;
        String jsonString;
        ResultBuilder.logHeadersFromResponse(response);
        int status = response.getStatusLine().getStatusCode();
        switch (status) {
            case 404: {
                return new RepositoryResult(4, "Cannot find " + classifier);
            }
            case 400: {
                return new RepositoryResult(2, INVALID_PARAMETERS);
            }
            case 500: {
                return new RepositoryResult(3, "Internal server error: " + status);
            }
            case 401: {
                return new RepositoryResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
        }
        HttpEntity entity = response.getEntity();
        try {
            try {
                jsonString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (Exception e) {
                RepositoryResult repositoryResult = new RepositoryResult(1, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString());
                NetworkUtils.consumeEntity(entity);
                return repositoryResult;
            }
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
        if (jsonString == null || "".equals(jsonString.trim())) {
            String message = NO_MESSAGE_IN_SERVER_RESPONSE;
            return new RepositoryResult(1, message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The body returned from the server is in json format: \n" + jsonString));
        }
        try {
            jsonResponse = JSONParser.parseJsonResponse(jsonString);
        }
        catch (SAXException e) {
            return new RepositoryResult(1, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString());
        }
        if (200 != status) {
            String message = JSONParser.getStringValue(jsonResponse, TEXT);
            String messageId = JSONParser.getStringValue(jsonResponse, ID);
            message = message == null ? "Unable to find result in json response from server" : message;
            ResultBuilder.logMessageDetails(message, messageId);
            return new RepositoryResult(1, message);
        }
        String message = JSONParser.getStringValue(jsonResponse, classifier);
        if (message == null) {
            return new RepositoryResult(1, "Unable to find result in json response from server", new String[0]);
        }
        StringTokenizer st = new StringTokenizer(message, ",");
        String[] resultEntites = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            resultEntites[i] = (String)st.nextElement();
            ++i;
        }
        return new RepositoryResult(0, message, resultEntites);
    }

    public static boolean isOrchestratorEndpoint(HttpResponse response) {
        Header domainHeader;
        Header deployHeader = response.getFirstHeader(DEPLOY_HEADER);
        if (deployHeader != null ^ (domainHeader = response.getFirstHeader(DOMAIN_HEADER)) != null) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received server headers: " + (deployHeader == null ? "" : DEPLOY_HEADER) + " " + (domainHeader == null ? "" : DOMAIN_HEADER)));
        }
        return false;
    }

    private static String getStackTrace(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static ComponentAttributesResult buildComponentAttributesResult(HttpResponse response) {
        JsonObject jsonResponse;
        String jsonString;
        int status = response.getStatusLine().getStatusCode();
        switch (status) {
            case 404: {
                return new ComponentAttributesResult(4, "REST service not found");
            }
            case 400: {
                return new ComponentAttributesResult(2, "Invalid parameters");
            }
            case 500: {
                return new ComponentAttributesResult(3, "Internal server error: " + status);
            }
            case 401: {
                return new ComponentAttributesResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
            case 503: {
                return new ComponentAttributesResult(3, SERVICE_UNAVAILABLE_MESSAGE);
            }
        }
        if (!ResultBuilder.isOrchestratorEndpoint(response)) {
            NetworkUtils.consumeEntity(response);
            logger.warn((Object)"Missing header [X-DomainController] in server response. The check will be skipped.");
            return new ComponentAttributesResult(3, UNKNOWN_HOST_MESSAGE);
        }
        HttpEntity entity = response.getEntity();
        try {
            try {
                jsonString = EntityUtils.toString((HttpEntity)entity);
            }
            catch (Exception e) {
                ComponentAttributesResult componentAttributesResult = new ComponentAttributesResult(1, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString());
                NetworkUtils.consumeEntity(entity);
                return componentAttributesResult;
            }
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
        if (jsonString == null || "".equals(jsonString.trim())) {
            String message = NO_MESSAGE_IN_SERVER_RESPONSE;
            return new ComponentAttributesResult(1, message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The body returned from the server is in json format: \n" + jsonString));
        }
        try {
            jsonResponse = JSONParser.parseJsonResponse(jsonString);
        }
        catch (SAXException e) {
            return new ComponentAttributesResult(1, UNABLE_TO_PARSE_JSON_RESPONSE, e.toString());
        }
        if (200 != status) {
            String message = JSONParser.getStringValue(jsonResponse, TEXT);
            String messageId = JSONParser.getStringValue(jsonResponse, ID);
            message = message == null ? "Unable to find result in json response from server" : message;
            ResultBuilder.logMessageDetails(message, messageId);
            return new ComponentAttributesResult(1, message);
        }
        ComponentAttributesResult result = null;
        try {
            result = new ComponentAttributesResult(0, jsonResponse);
        }
        catch (Exception e) {
            return new ComponentAttributesResult(1, "Error occurred while parsing the server response", e.toString());
        }
        return result;
    }

    public static String getErrorMessageForHttpStatusUnauthorized(HttpResponse response) {
        String message = LogonUtils.getAuthenticationFailureErrorMessage((HttpResponse)response);
        return message != null ? message : INVALID_USER_MSG;
    }

    private static void logMessageDetails(String message, String messageId) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format(LOG_MEESAGE_PATTERN, message, messageId));
        }
    }

    public static ComponentAttributesResult createComponentAttributesResultFromAppResponse(int code, ApplicationResponse applicationResponse) {
        ComponentAttributesResult result = new ComponentAttributesResult(code, null, null);
        ResultBuilder.processGeneralParams(applicationResponse, result);
        ResultBuilder.processEnviormentVars(applicationResponse, result);
        ResultBuilder.processRuntimeArgs(applicationResponse, result);
        return result;
    }

    private static void processGeneralParams(ApplicationResponse applicationResponse, ComponentAttributesResult componentAttributeResult) {
        componentAttributeResult.setRuntimeId(applicationResponse.getRuntimeName());
        componentAttributeResult.setRuntimeVersion(applicationResponse.getRuntimeVersion());
        componentAttributeResult.setVersionPinned(null);
        componentAttributeResult.setJpaasServices(PropertiesConstants.ALL_SERVICES);
        componentAttributeResult.setMinVmCount(applicationResponse.getMinProcesses());
        componentAttributeResult.setMaxVmCount(applicationResponse.getMaxProcesses());
        componentAttributeResult.setVmSize(applicationResponse.getComputeUnitSize());
    }

    private static void processEnviormentVars(ApplicationResponse applicationResponse, ComponentAttributesResult componentAttributeResult) {
        Map enviormentVariables = applicationResponse.getMetadata();
        ArrayList<String> enviormentVariablesList = new ArrayList<String>();
        String enviormentVariable = null;
        if (enviormentVariables != null) {
            for (String key : enviormentVariables.keySet()) {
                enviormentVariable = String.valueOf(key) + "=" + (String)enviormentVariables.get(key);
                enviormentVariablesList.add(enviormentVariable.replace("_ENV_", ""));
            }
        }
        componentAttributeResult.setEnvironmentVariables(enviormentVariablesList);
    }

    private static void processRuntimeArgs(ApplicationResponse applicationResponse, ComponentAttributesResult componentAttributeResult) {
        List runtimeArguments = applicationResponse.getRuntimeArguments();
        if (runtimeArguments == null) {
            return;
        }
        for (RuntimeArgument runtimeArgument : runtimeArguments) {
            String vmArgumentsStr;
            String key = runtimeArgument.getKey();
            String value = runtimeArgument.getValue();
            if (key.equals("compressibleMimeTypes")) {
                componentAttributeResult.setCompressionMimeType(value);
                continue;
            }
            if (key.equals("compression")) {
                componentAttributeResult.setCompressionEnabled(value);
                continue;
            }
            if (key.equals("compressionMinSize")) {
                componentAttributeResult.setCompressionMinSize(value);
                continue;
            }
            if (key.equals("connectionTimeout")) {
                componentAttributeResult.setConnectionTimeout(value);
                continue;
            }
            if (key.equals("jvmVersion")) {
                componentAttributeResult.setJavaVersion(value);
                continue;
            }
            if (key.equals("maxThreads")) {
                componentAttributeResult.setMaxThreads(value);
                continue;
            }
            if (key.equals("uriEncoding")) {
                componentAttributeResult.setUriEncoding(value);
                continue;
            }
            if (!key.equals("vmArguments") || (vmArgumentsStr = value) == null) continue;
            componentAttributeResult.setVmArgs(Arrays.asList(vmArgumentsStr.split(" ")));
        }
    }

    public Map<String, StatusResult> extractResultFromResponse(HttpResponse response, String space, String application, String host) throws ParseException, IOException {
        HttpEntity entity = null;
        try {
            entity = response.getEntity();
            String json = EntityUtils.toString((HttpEntity)entity);
            Gson gson = new Gson();
            Map<String, StatusResult> invalidServerResponse = this.populateMapWithInvalidServerResponse(response);
            if (!invalidServerResponse.isEmpty()) {
                Map<String, StatusResult> map = invalidServerResponse;
                return map;
            }
            List responseEntities = (List)gson.fromJson(json, new TypeToken<ArrayList<ResponseEntity<StatusResponseMetadataWithComponent, ApplicationStateEntity>>>(){}.getType());
            Map<String, StatusResult> resultFromResponseEntities = this.extractResultFromResponseEntities(responseEntities, space, application, host);
            if (resultFromResponseEntities.get("_application_state") == null) {
                StatusResult appStatus = this.extractApplicationStateFromResponseHeader(response);
                resultFromResponseEntities.put("_application_state", appStatus);
            }
            Map<String, StatusResult> map = resultFromResponseEntities;
            return map;
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
    }

    private Map<String, StatusResult> extractResultFromResponseEntities(List<ResponseEntity<StatusResponseMetadataWithComponent, ApplicationStateEntity>> responseEntities, String space, String application, String host) {
        TreeMap<String, StatusResult> result = new TreeMap<String, StatusResult>();
        Gson gson = new Gson();
        ReadDetailedApplicationStateClient ras = new ReadDetailedApplicationStateClient(space, application, host, null, null);
        for (ResponseEntity<StatusResponseMetadataWithComponent, ApplicationStateEntity> re : responseEntities) {
            String component = ((StatusResponseMetadataWithComponent)re.getMetadata()).getComponent();
            StatusResult statusResult = null;
            if (component == null) {
                component = "_application_state";
                statusResult = ResultBuilder.buildStatusResult(0, gson.toJson(re, new TypeToken<ResponseEntity<StatusResponseMetadataWithComponent, ApplicationStateEntity>>(){}.getType()), host, null, application, space, ((ApplicationStateEntity)re.getEntity()).getApplicationState());
            } else {
                statusResult = ras.processResponse(0, gson.toJson(re, new TypeToken<ResponseEntity<StatusResponseMetadataWithComponent, ApplicationStateEntity>>(){}.getType()));
            }
            result.put(component, statusResult);
        }
        return result;
    }

    private StatusResult extractApplicationStateFromResponseHeader(HttpResponse response) {
        Header appStateHeader = response.getFirstHeader("_application_state");
        if (appStateHeader == null) {
            logger.error((Object)"Header with name [_application_state] was not found in the response. Will return UNKNOWN for application state");
            return new StatusResult(1, Status.UNKNOWN, null);
        }
        String appStateAsStr = appStateHeader.getValue();
        Status appState = null;
        try {
            appState = Status.valueOf(appStateAsStr);
        }
        catch (Exception e) {
            logger.error((Object)("Error parsing application state received from server - [" + appStateAsStr + "]. Evaluating the application state to UNKNOWN"), (Throwable)e);
            return new StatusResult(1, Status.UNKNOWN, null);
        }
        return new StatusResult(0, appState, null);
    }

    private Map<String, StatusResult> populateMapWithInvalidServerResponse(HttpResponse response) {
        TreeMap<String, StatusResult> result = new TreeMap<String, StatusResult>();
        switch (response.getStatusLine().getStatusCode()) {
            case 404: 
            case 580: {
                result.put("_application_state", new StatusResult(4, Status.NOT_FOUND, "Application not found"));
                break;
            }
            case 400: {
                result.put("_application_state", new StatusResult(2, "Invalid parameters. "));
                break;
            }
            case 500: {
                result.put("_application_state", new StatusResult(3, "Internal server error: " + response.getStatusLine().getStatusCode()));
                break;
            }
            case 401: {
                result.put("_application_state", new StatusResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response)));
            }
        }
        return result;
    }
}

