/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaasrepository.api;

import com.google.gson.Gson;
import com.sap.core.jpaasrepository.api.MalformedJsonElementException;
import com.sap.core.jpaasrepository.api.ServiceDescriptor;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Properties;

public class Descriptor {
    public static final byte TYPE_JP_SPACE = 1;
    public static final byte TYPE_JP_APPLIANCE = 2;
    public static final byte TYPE_JP_COMPONENT = 3;
    private Properties attributes = new Properties();
    private Collection<ServiceDescriptor> services;
    byte containerType;

    private Descriptor() {
    }

    public Descriptor(byte containerType) {
        this.containerType = containerType;
    }

    public static Descriptor createDescriptor(byte containerType) {
        return new Descriptor(containerType);
    }

    public String get(String key) {
        return this.attributes.getProperty(key);
    }

    public void set(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public <T> T getAs(String key, Class<T> t) throws MalformedJsonElementException {
        if (key == null) {
            throw new NullPointerException("Specified key should not be null");
        }
        if (t == null) {
            throw new NullPointerException("Specified class should not be null");
        }
        String objectAsJson = this.attributes.getProperty(key);
        if (objectAsJson == null) {
            return null;
        }
        Gson gson = new Gson();
        try {
            return (T)gson.fromJson(objectAsJson, t);
        }
        catch (Exception e) {
            throw new MalformedJsonElementException("Unable to transform Json " + objectAsJson + " into an object of class " + t, e);
        }
    }

    public <T> T getAs(String key, Type t) throws MalformedJsonElementException {
        if (key == null) {
            throw new NullPointerException("Specified key should not be null");
        }
        if (t == null) {
            throw new NullPointerException("Specified type should not be null");
        }
        String objectAsJson = this.attributes.getProperty(key);
        if (objectAsJson == null) {
            return null;
        }
        Gson gson = new Gson();
        try {
            return (T)gson.fromJson(objectAsJson, t);
        }
        catch (Exception e) {
            throw new MalformedJsonElementException("Unable to transform Json " + objectAsJson + " into an object of type " + t, e);
        }
    }

    public void setAs(String key, Object value) {
        if (value == null) {
            throw new NullPointerException("Specified value should not be null");
        }
        if (key == null) {
            throw new NullPointerException("Specified key should not be null");
        }
        Gson gson = new Gson();
        try {
            String objectAsJson = gson.toJson(value);
            if (objectAsJson == null) {
                throw new IllegalArgumentException("Unexpected null json representation for value [" + value.toString() + "] associated with key [" + key + "]");
            }
            this.attributes.put(key, objectAsJson);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to retrieve json representation for value [" + value.toString() + "] associated with key [" + key + "] ", e);
        }
    }

    void setContainerType(byte type) {
        this.containerType = type;
    }

    public String serializeToJson() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public static Descriptor deserializeFromJson(String json) {
        Gson gson = new Gson();
        return (Descriptor)gson.fromJson(json, Descriptor.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Descriptor{");
        sb.append("attributes=").append(this.attributes);
        sb.append(", services=").append(this.services);
        sb.append(", containerType=").append(this.containerType);
        sb.append('}');
        return sb.toString();
    }

    public Collection<ServiceDescriptor> getServices() {
        return this.services;
    }

    public void setServices(Collection<ServiceDescriptor> services) {
        this.services = services;
    }
}

