/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaasrepository.api;

public class ElasticityData {
    private int minVmCount;
    private int maxVmCount;
    public static final String ELASTICITY_DATA_KEY = "elasticity.data";

    public ElasticityData() {
        this.minVmCount = 1;
        this.maxVmCount = 1;
    }

    public ElasticityData(Integer min, Integer max) {
        if (min <= 0) {
            throw new IllegalArgumentException("Provided input for minimum [" + min + "] is invalid. Minimum value should be positive");
        }
        if (min > max) {
            throw new IllegalArgumentException("Provided input for minimum [" + min + "] and maximum [" + max + "] is invalid. Maximum value must not be less than the minimum value");
        }
        this.minVmCount = min;
        this.maxVmCount = max;
    }

    public int getMinVmCount() {
        return this.minVmCount;
    }

    public void setMinVmCount(Integer minVms) {
        this.minVmCount = minVms;
    }

    public int getMaxVmCount() {
        return this.maxVmCount;
    }

    public void setMaxVmCount(Integer maxVms) {
        this.maxVmCount = maxVms;
    }

    public String toString() {
        return "[" + this.minVmCount + "," + this.maxVmCount + "]";
    }
}

