/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.commons.impl.json;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.sap.cloud.runtime.tomcat.commons.shared.json.JsonParser;
import com.sap.cloud.runtime.tomcat.commons.shared.json.JsonParsingException;
import java.io.IOException;
import java.io.Reader;

final class GsonAdapter
implements JsonParser {
    private final Gson gson;

    public GsonAdapter(Gson gson) {
        this.gson = gson;
    }

    public <T> T parse(Reader reader, Class<T> type) throws IOException, JsonParsingException {
        try {
            return (T)this.gson.fromJson(reader, type);
        }
        catch (JsonIOException ioe) {
            throw new IOException(ioe);
        }
        catch (Exception e) {
            throw new JsonParsingException((Throwable)e);
        }
    }

    public String toString() {
        return "GsonAdapter{gson=" + this.gson + '}';
    }
}

