/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.ops.converters;

import com.beust.jcommander.IStringConverter;
import com.sap.cloud.account.ops.entites.Quota;
import com.sap.cloud.account.ops.entites.QuotaType;
import java.math.BigDecimal;
import java.util.ResourceBundle;

public class QuotaAmountConverter
implements IStringConverter<Quota> {
    private static final String DEFAULT_VALUE = "1";
    public static final String VM_PARAMS_PREFIX = "vm.";

    @Override
    public Quota convert(String value) {
        String[] split = value.split(":");
        Quota quota = new Quota();
        String code = split[0];
        String amount = DEFAULT_VALUE;
        if (split.length == 2) {
            amount = split[1].trim();
        }
        quota.setAmount(new BigDecimal(amount));
        QuotaType quotaType = new QuotaType();
        quotaType.setCode(this.findValueByKey(code));
        quota.setQuotaType(quotaType);
        return quota;
    }

    private String findValueByKey(String quotaCode) {
        ResourceBundle paramsBundle = ResourceBundle.getBundle("parameters");
        String key = VM_PARAMS_PREFIX + quotaCode;
        return paramsBundle.getString(key);
    }
}

