/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.ops.entites;

import com.sap.cloud.account.ops.entites.Account;
import com.sap.cloud.account.ops.entites.QuotaType;
import java.math.BigDecimal;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Quota
implements Comparable<Quota> {
    private BigDecimal amount;
    private QuotaType quotaType;
    private Account account;

    public Quota() {
    }

    public Quota(Quota quota) {
        this.quotaType = quota.quotaType;
        this.amount = quota.amount;
        this.account = quota.account;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    public void setQuotaType(QuotaType quotaType) {
        this.quotaType = quotaType;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.quotaType == null ? 0 : this.quotaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quota other = (Quota)obj;
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        return !(this.quotaType == null ? other.quotaType != null : !this.quotaType.equals(other.quotaType));
    }

    public String toString() {
        String codePrefix = "code.";
        ResourceBundle params = ResourceBundle.getBundle("parameters");
        String code = "";
        try {
            code = params.getString(codePrefix + this.quotaType.getCode());
        }
        catch (MissingResourceException e) {
            code = this.quotaType.getCode();
        }
        if (this.account != null) {
            return String.format("%-32s%-10s%n", this.account.getName(), code + ":" + this.amount.intValue());
        }
        return code + ":" + this.amount.intValue();
    }

    @Override
    public int compareTo(Quota o) {
        if (o == null || o.getQuotaType() == null) {
            return 1;
        }
        return this.getQuotaType().getCode().compareTo(o.getQuotaType().getCode());
    }
}

