/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.ops.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommandMessages {
    private static final String RESOURCE_BUNDLE_NAME = "messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("messages");
    public static final String GENERAL = "general";
    public static final String LIST_ACCOUNTS = "list";
    public static final String CREATE_ACCOUNT = "create";
    public static final String DELETE_ACCOUNT = "delete";
    public static final String SET_QUOTA = "setquota";
    private String group;

    private CommandMessages(String group) {
        this.group = group;
    }

    public static CommandMessages getInstance(String group) {
        return new CommandMessages(group);
    }

    public static CommandMessages getGeneralGroupInstance() {
        return new CommandMessages(GENERAL);
    }

    public String getMessage(String key) {
        try {
            return RESOURCE_BUNDLE.getString(this.group + "." + key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getGeneralMessage(String key) {
        try {
            return RESOURCE_BUNDLE.getString("general." + key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getMessage(int statusCode) {
        try {
            return RESOURCE_BUNDLE.getString(this.group + "." + statusCode);
        }
        catch (MissingResourceException e) {
            return "Missing message for status code:" + statusCode;
        }
    }

    public String getMessage(String key, Object ... params) {
        return MessageFormat.format(this.getMessage(key), params);
    }

    public String getGeneralMessage(String key, Object ... params) {
        return MessageFormat.format(this.getGeneralMessage(key), params);
    }

    public String getMessage(int satusCode, Object ... params) {
        String message = this.getMessage(satusCode);
        return MessageFormat.format(message, params);
    }
}

