/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.ops.validators;

import com.beust.jcommander.ParameterException;
import com.sap.cloud.account.ops.i18n.CommandMessages;
import com.sap.cloud.account.ops.validators.sibling.EmptyParameterValueValidator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class QuotaComplexInputValidator
extends EmptyParameterValueValidator {
    @Override
    public void validateParameter(String name, String value) {
        ResourceBundle bundle = ResourceBundle.getBundle("parameters");
        CommandMessages messages = CommandMessages.getInstance("setquota");
        String msgInvalidAmount = messages.getMessage("amount.invalid");
        String[] split = value.split(":");
        if (split.length != 1 && split.length != 2) {
            throw new ParameterException(msgInvalidAmount);
        }
        String key = "vm." + split[0];
        try {
            bundle.getString(key);
        }
        catch (MissingResourceException e) {
            String msg = messages.getMessage("size.validation", value);
            throw new ParameterException(msg);
        }
        if (split.length == 2) {
            try {
                long parsedValue = Long.parseLong(split[1].trim());
                if (parsedValue < 0L) {
                    throw new ParameterException(msgInvalidAmount);
                }
            }
            catch (NumberFormatException e) {
                throw new ParameterException(msgInvalidAmount);
            }
        }
    }
}

