/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.account.ops.validators.sibling;

import com.beust.jcommander.ParameterException;
import com.sap.cloud.account.ops.i18n.CommandMessages;
import com.sap.cloud.account.ops.validators.sibling.EmptyParameterValueValidator;
import com.sap.cloud.commercial.account.ops.utils.sibling.CloneParameterParser;
import java.util.HashSet;
import java.util.Set;

public class CloneParameterValidator
extends EmptyParameterValueValidator {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SPACE = " ";
    private static final Set<String> SUPPORTED_VALUES = new HashSet<String>();

    @Override
    public void validateParameter(String name, String value) {
        String delimiter;
        String csv = CloneParameterParser.parse(value);
        if (this.isEmpty(csv)) {
            this.throwGeneralEmptyParameterException(name);
        }
        if (csv.contains(SINGLE_QUOTE) || csv.contains(DOUBLE_QUOTE)) {
            this.throwInvalidParameterException(name, "internal.quotes");
        }
        if (csv.contains(delimiter = CloneParameterParser.getDelimiter())) {
            String[] values = csv.split(delimiter);
            if (values.length < 1) {
                this.throwInvalidParameterException(name, "values.empty");
            }
            for (int i = 0; i < values.length; ++i) {
                String currentValue = values[i];
                if (this.isEmpty(currentValue)) {
                    this.throwInvalidParameterException(name, "values.empty");
                }
                if (currentValue.contains(SPACE)) {
                    this.throwInvalidParameterException(name, "values.spaces");
                }
                this.checkIfSupported(name, currentValue);
            }
        } else {
            if (csv.contains(SPACE)) {
                this.throwInvalidParameterException(name, "values.spaces");
            }
            this.checkIfSupported(name, csv);
        }
    }

    private void checkIfSupported(String name, String value) {
        if (!SUPPORTED_VALUES.contains(value)) {
            this.throwInvalidParameterException(name, value, "values.unsupported");
        }
    }

    private void throwInvalidParameterException(String name, String messageId) {
        this.throwInvalidParameterException(name, null, messageId);
    }

    private void throwInvalidParameterException(String name, String value, String messageId) {
        String message = this.getMessages().getMessage("invalid.clone.conf.types." + messageId, name, value);
        throw new ParameterException(message);
    }

    private CommandMessages getMessages() {
        CommandMessages messages = CommandMessages.getInstance("create");
        return messages;
    }

    static {
        SUPPORTED_VALUES.add("trust");
        SUPPORTED_VALUES.add("members");
        SUPPORTED_VALUES.add("destinations");
        SUPPORTED_VALUES.add("all");
    }
}

