/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.sap.cloud.account.ops.i18n.CommandMessages;
import com.sap.cloud.commercial.account.ops.utils.HttpClientUtils;
import com.sap.cloud.commercial.account.ops.utils.ResponseBuilderUtils;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public abstract class AccountOperationsAbstractCommand
extends AccountCommand {
    public static final String HOST_COMMANDSTUNNEL_FACTORY_EU1_ROT = "https://services.hana.ondemand.com";
    protected static final String SERVICES = "services";
    protected static final String GROUP_ACCOUNT_OPERATIONS = "account";
    protected static final String DESCRIPTION_LIST_SIBLING_ACCOUNTS = "Lists all accounts for the customer presented by the given base account. The user belongs to the base account.";
    protected static final String COMMAND_NAME_LIST_SIBLING_ACCOUNTS = "list-accounts";
    protected static final String COMMAND_NAME_DELETE_SIBLING_ACCOUNT = "delete-account";
    protected static final String COMMAND_NAME_CREATE_SIBLING_ACCOUNT = "create-account";
    protected static final String COMMAND_NAME_SET_QUOTA = "set-quota";
    protected static final String TUNNEL_ALIAS = "/services/%s/instances/%s";
    protected static final String REST_PERSISTENCE_API_ROOT = "/services/%s/instances/%s/persistence/%s/%s/";
    protected static final String REST_DELETE_SIBLING_ALIAS = "/services/%s/instances/%s/accounts/%s/accounts/siblings";
    protected static final String REST_SUBSCRIPTION_API_GET_SUBSCRIBED_APPLICATIONS = "/services/%s/instances/%s/subscriptions/%s/";
    protected static final String DISPATCHER_HOST = "https://dispatcher.%s";
    protected static final String DISPATCHER_API_ALIAS = "/hcproxy/b/api/";
    protected static final String GET_HTML5_APPLICATIONS = "https://dispatcher.%s/hcproxy/b/api/accounts/%s/applications";
    protected static final String REST_SIBLINGS_ALIAS = "/services/%s/instances/%s/accounts/%s/accounts/siblings";
    protected static final String REST_CIS_SIBLINGS_CLONE_STATUS_ALIAS = "/services/%s/instances/%s/cisaccounts/%s/operations/clone-conf/state";
    protected static final String REST_CIS_SIBLINGS_ALIAS = "/services/%s/instances/%s/cisaccounts/%s/accounts/siblings";
    protected static final String REST_QUOTAS_ALIAS = "/services/%s/instances/%s/accounts/%s/quotas/quota";
    protected static final String REST_QUOTAS_ALIAS_GET = "/services/%s/instances/%s/accounts/%s/quotas";
    protected static final String REST_GLOBAL_QUOTAS_ALIAS_GET = "/services/%s/instances/%s/accounts/%s/quotas/global-quota";
    protected static final String MSG_KEY_ACCOUNTS = "accounts";
    protected static final String MSG_KEY_INVALID_HOST = "invalidHost";
    protected static final String MSG_KEY_ACCOUNTS_NAME = "accounts.name";
    protected static final String MSG_KEY_ACCOUNTS_DISPLAY_NAME = "accounts.displayName";
    protected static final String MSG_KEY_ACCOUNTS_CREATION_TIME = "accounts.creationTime";
    protected static final String MSG_KEY_UNKNOWN_HTTP_ERROR = "unknown.http.error";
    public static final String MSG_KEY_UKNOWN_PROBLEM = "unknown.problem";
    public static final String MSG_KEY_PARAMETER_EMPTY_VALUE = "parameter.empty.value";
    protected static final String MSG_KEY_SIMILAR_ACCOUNTS = "accounts.similar";
    protected static final String MSG_KEY_CONNECTING_TO_URL = "accounts.connecting";
    protected static final String MSG_KEY_INVALID_LANDSCAPE = "invalid.landscape";
    protected static final String MSG_KEY_SCHEMAS_EXISTS = "persistence.schemas.exist";
    protected static final String MSG_KEY_PERSISTENCE_DBMS_EXISTS = "persistence.dbms.exists";
    protected static final String MSG_KEY_PERSISTENCE_API_ERROR = "persistence.api.error";
    protected static final String MSG_KEY_PERSISTENCE_DBMS_ERROR = "persistence.dbms.error";
    protected static final String MSG_KEY_SUBSCRIPTION_API_ERROR = "subscription.api.error";
    protected static final String MSG_KEY_HTML5APP_EXISTS = "html5application.exist";
    protected static final String MSG_KEY_SUBSCRIPTIONS_EXISTS = "subscriptions.exist";
    protected static final String MSG_KEY_DELETE_GENERAL_NOT_AUTHORIZED = "401";
    protected static final String MSG_KEY_SUCCESS = "success.message";
    protected static final String MSG_KEY_ERROR_FRONTEND = "error.frontend";
    protected static final String MSG_KEY_CLONE_REQUESTED = "clone.requested";
    protected static final String MSG_KEY_CLONE_STATUS = "clone.status";
    protected static final String MSG_KEY_CLONE_PROGRESS_STARTED = "clone.progress.started";
    protected static final String MSG_KEY_CLONE_PROGRESS_COMPLETED = "clone.progress.completed";
    protected static final String MSG_KEY_CLONE_PROGRESS_TIMEOUT = "clone.progress.timeout";
    protected static final String MSG_KEY_CLONE_PROGRESS_NOTIFY_WORKING = "clone.progress.notify.working";
    protected static final String MSG_KEY_CLONE_PROGRESS_NOTIFY_STILL_WORKING = "clone.progress.notify.still.working";
    protected static final String MSG_KEY_CLONE_PROGRESS_NOTIFY_ELAPSED_MINUTES = "clone.progress.notify.elapsed.minutes";
    protected static final String MSG_KEY_CLONE_ERROR_TIMEOUT = "clone.error.timeout";
    protected static final String MSG_KEY_MISSING_CMD_PARAMS = "missing.cmd.params";
    protected static final String MSG_KEY_COMPUTE_UNIT_QUOTA = "compute.unit.quota";
    protected static final String MSG_KEY_PURCHASED_COMPUTE_UNITS = "compute.unit.purchased";
    protected static final String MSG_KEY_COMPUTE_UNIT = "compute.unit";
    protected static final String MSG_KEY_FREE_COMPUTE_UNITS = "compute.unit.free";
    protected static final String MSG_KEY_WARN_NOT_COMPLETE = "warn.not.completed";
    protected static final String MSG_KEY_PURCHASED = "purchased";
    protected static final String MSG_KEY_QUOTA_UNKNOWN = "quotas.unknown ";
    protected static final String JSON_PROP_ACCOUNT_NAME = "name";
    protected static final String JSON_PROP_ACCOUNT_DISPLAY_NAME = "displayName";
    protected static final String PROP_PUBLIC_REST_VERSION = "public.rest.version";
    protected static final String PROP_TUNNEL_REST_VERSION = "tunnel.rest.version";
    protected static final String PROP_TUNNEL_SHORT_URL = "tunnel.short.url";
    private static final String ARG_ACCOUNT = "-a";
    private static final String ARG_ACCOUNT_LONG = "--account";
    protected static final String MSG_KEY_LIST_INVALID_HOST = "list.invalidHost";
    protected String tunnelVersion = "v1";
    protected String persistanceAPIVersion = "v1";
    protected String subscriptionsAPIVersion = "v1";
    protected String domainDbPublicRestVersion = "v1";
    protected String cisPublicRestVersion = "v1";
    protected CommandMessages messages;
    protected HttpClient httpClient = null;
    private String tunnelShortUrl = "services";
    protected ResourceBundle paramsBundle;

    @Override
    public void init() {
        super.init();
        this.paramsBundle = ResourceBundle.getBundle("parameters");
        this.messages = CommandMessages.getInstance(this.getMessageGroup());
        try {
            this.tunnelVersion = this.paramsBundle.getString(PROP_TUNNEL_REST_VERSION);
            this.tunnelShortUrl = this.paramsBundle.getString(PROP_TUNNEL_SHORT_URL);
            this.domainDbPublicRestVersion = this.paramsBundle.getString(PROP_PUBLIC_REST_VERSION);
        }
        catch (MissingResourceException exc) {
            this.getLogger().error("Could not obtain config parameters from parameters.properties", exc);
            String msg = this.messages.getGeneralMessage(MSG_KEY_MISSING_CMD_PARAMS);
            throw new FrontendException(msg, 20);
        }
    }

    @Override
    public String getGroup() {
        return GROUP_ACCOUNT_OPERATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CheckHelper.checkArgSpecified(ARG_ACCOUNT, ARG_ACCOUNT_LONG, this.getAccount());
            this.handleHostArgument();
            String initialMsg = ResponseBuilderUtils.buildInitialMessage(this.getName(), this.getAccount(), this.getHost(), this.getUser(), this.messages, this.getAdditionalParametersToDisplay(), this.getAdditionalDetailsToDisplay());
            DumpHelper.dumpWithNewLine(initialMsg);
            this.httpClient = this.createFreshHttpClient();
            this.executeCommand(this.httpClient);
        }
        finally {
            this.cleanup();
        }
    }

    protected void handleHostArgument() {
        String inputHost = super.getHost();
        try {
            URL url = new URL(inputHost);
            if (!url.getHost().startsWith(this.tunnelShortUrl)) {
                inputHost = url.getProtocol() + "://" + this.tunnelShortUrl + "." + url.getHost();
            }
        }
        catch (MalformedURLException e) {
            DumpHelper.dumpErrorMessage(this.messages.getMessage(MSG_KEY_INVALID_HOST, inputHost));
        }
        this.host = inputHost;
    }

    protected Map<String, String> getAdditionalParametersToDisplay() {
        return new HashMap<String, String>();
    }

    protected String getAdditionalDetailsToDisplay() {
        return null;
    }

    protected abstract void executeCommand(HttpClient var1) throws CommandException;

    protected abstract void handleOKResponse(HttpResponse var1) throws IOException;

    protected abstract String getMessageGroup();

    protected abstract String getUrl();

    private void handleErrorResponse(HttpResponse httpResponse) throws IOException {
        int status = httpResponse.getStatusLine().getStatusCode();
        switch (status) {
            case 400: {
                throw new FrontendException(this.messages.getMessage(status, this.getAccount()), 166);
            }
            case 404: {
                throw new FrontendException(this.messages.getMessage(status, this.getAccount()), 167);
            }
            case 409: {
                throw new FrontendException(this.messages.getMessage(status, this.getAccount()), 168);
            }
            case 500: {
                throw new BackendException(this.messages.getMessage(status, this.getAccount()), 210);
            }
            case 401: 
            case 403: {
                throw new SecurityException(this.messages.getMessage(status, this.getAccount()), 111);
            }
            case 412: {
                throw new SecurityException(this.messages.getMessage(status, this.getAccount()), 415);
            }
        }
        throw new CommandException(this.messages.getGeneralMessage(MSG_KEY_UNKNOWN_HTTP_ERROR, status), 169);
    }

    @Override
    public void cleanup() {
        HttpClientUtils.releaseHttpClient(this.httpClient);
    }

    public abstract Logger getLogger();

    protected HttpClient createFreshHttpClient() {
        HttpClient client = super.getHttpClient();
        client.getParams().setParameter("http.protocol.content-charset", "UTF-8");
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse(HttpResponse requestResponse, int successCode) throws IOException {
        int statusCode = requestResponse.getStatusLine().getStatusCode();
        HttpEntity recievedEntity = requestResponse.getEntity();
        try {
            if (statusCode == successCode) {
                this.handleOKResponse(requestResponse);
            } else {
                this.handleErrorResponse(requestResponse);
            }
        }
        finally {
            EntityUtils.consume(recievedEntity);
        }
    }
}

