/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.sap.cloud.commercial.account.ops.commands.AccountOperationsWithQuotaManipulationCommand;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public abstract class AccountOperationsWithHeaderProcessingCommand
extends AccountOperationsWithQuotaManipulationCommand {
    protected static final String ERROR_MESSAGE_HEADER = "x-systemdb-errormsg";
    protected static final String ERROR_FIELDINFO_HEADER = "x-systemdb-fieldinfo";

    protected void handleErrorResponse(int status, HttpResponse response) throws IOException {
        String msg = this.messages.getMessage(status, this.getAccount());
        switch (status) {
            case 400: {
                this.processHeadersFromErrorMessage(response);
                throw new FrontendException(msg, 166);
            }
            case 404: {
                this.processHeadersFromErrorMessage(response);
                throw new FrontendException(msg, 167);
            }
            case 409: {
                this.processHeadersFromErrorMessage(response);
                throw new FrontendException(msg, 168);
            }
            case 500: {
                this.processHeadersFromErrorMessage(response);
                throw new BackendException(msg, 210);
            }
            case 401: 
            case 403: {
                this.processHeadersFromErrorMessage(response);
                throw new SecurityException(msg, 111);
            }
        }
        throw new CommandException(this.messages.getGeneralMessage("unknown.http.error", status), 169);
    }

    protected boolean headerHasErrorMessages(Header header) {
        return header != null && header.getValue() != null && !header.getValue().trim().isEmpty();
    }

    public abstract void processHeadersFromErrorMessage(HttpResponse var1);
}

