/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.google.gson.reflect.TypeToken;
import com.sap.cloud.account.ops.entites.Quota;
import com.sap.cloud.account.ops.entites.QuotaType;
import com.sap.cloud.account.ops.exceptions.UnexpectedRESTResultException;
import com.sap.cloud.commercial.account.ops.commands.AccountOperationsAbstractCommand;
import com.sap.cloud.commercial.account.ops.utils.HttpClientUtils;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;

public abstract class AccountOperationsWithQuotaManipulationCommand
extends AccountOperationsAbstractCommand {
    protected List<Quota> getListOfQuotas(String quotaGetUrl) {
        try {
            return this.getQuotas(quotaGetUrl);
        }
        catch (IOException e) {
            this.getLogger().warn("Could not prepare quota items to display for account: " + this.getAccount(), e);
            this.dumpWarningMessageForQuotas("quotas.unknown ", false, null);
        }
        catch (UnexpectedRESTResultException e) {
            this.getLogger().warn("Unexpected rest result", e);
            this.dumpWarningMessageForQuotas("warn.not.completed", false, e.getStatusCode());
        }
        return null;
    }

    protected String buildGlobalAndFreeQuotasMessage(List<Quota> listOfQuotas) {
        HashMap<String, Quota> globalQuotas = new HashMap<String, Quota>();
        HashMap<String, Quota> freeQuotas = new HashMap<String, Quota>();
        this.fillGlobalAndFreeQuotas("/services/%s/instances/%s/accounts/%s/quotas/global-quota", globalQuotas, freeQuotas);
        this.calculateFreeQuota(listOfQuotas, freeQuotas);
        String lastMsg = this.messages.getGeneralMessage("compute.unit.purchased", globalQuotas.values()) + "\n" + this.messages.getGeneralMessage("compute.unit.free", freeQuotas.values());
        return lastMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Quota> getQuotas(String quotaGetUrl) throws UnexpectedRESTResultException, IOException {
        String url = this.getHost() + String.format(quotaGetUrl, this.tunnelVersion, this.getAccount(), this.domainDbPublicRestVersion);
        HttpClient quotasHttpClient = this.createFreshHttpClient();
        List result = Collections.emptyList();
        try {
            Type type = new TypeToken<List<Quota>>(){}.getType();
            result = (List)HttpClientUtils.executeQuery(HttpClientUtils.HTTPMethod.GET, url, null, Arrays.asList(200, 204), null, quotasHttpClient, type);
        }
        finally {
            HttpClientUtils.releaseHttpClient(quotasHttpClient);
        }
        return result;
    }

    private void dumpWarningMessageForQuotas(String msgKey, boolean isGlobalQuota, Integer statusCode) {
        String purchasedLabel = "";
        if (isGlobalQuota) {
            purchasedLabel = this.messages.getGeneralMessage("purchased");
        }
        DumpHelper.dumpWarningMessage(this.messages.getGeneralMessage(msgKey, purchasedLabel, statusCode));
    }

    private void calculateFreeQuota(List<Quota> listOfQuotas, Map<String, Quota> freeQuotas) {
        for (Quota quota : listOfQuotas) {
            String key = quota.getQuotaType().getCode();
            Quota freeQuota = freeQuotas.get(key);
            if (freeQuota == null || freeQuota.getAmount() == null) continue;
            BigDecimal newValue = freeQuota.getAmount().subtract(quota.getAmount());
            freeQuota.setAmount(newValue);
        }
    }

    private void fillGlobalAndFreeQuotas(String quotaGetUrl, Map<String, Quota> globalQuotas, Map<String, Quota> freeQuotas) {
        try {
            List<Quota> listOfQuotas = this.getQuotas(quotaGetUrl);
            for (Quota quota : listOfQuotas) {
                QuotaType quotaType = quota.getQuotaType();
                if (quotaType == null || !"COMPUTE_UNIT".equals(quotaType.getType())) continue;
                String key = quotaType.getCode();
                quota.setAccount(null);
                Quota freeQuota = new Quota(quota);
                freeQuotas.put(key, freeQuota);
                globalQuotas.put(key, quota);
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Could not prepare quota items to display for account: " + this.getAccount(), e);
            this.dumpWarningMessageForQuotas("quotas.unknown ", true, null);
        }
        catch (UnexpectedRESTResultException e) {
            this.getLogger().warn("Unexpected rest result", e);
            this.dumpWarningMessageForQuotas("warn.not.completed", true, e.getStatusCode());
        }
    }
}

