/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonElement;
import com.sap.cloud.account.ops.entites.Account;
import com.sap.cloud.account.ops.entites.AccountCreatedCloneConfWrapperDTO;
import com.sap.cloud.account.ops.entites.CloneOperationStateDetails;
import com.sap.cloud.account.ops.entites.ConfigurationType;
import com.sap.cloud.account.ops.validators.sibling.CloneParameterValidator;
import com.sap.cloud.account.ops.validators.sibling.EmptyParameterValueValidator;
import com.sap.cloud.commercial.account.ops.commands.AccountOperationsAbstractCommand;
import com.sap.cloud.commercial.account.ops.commands.clone.CloneConfigurationsProgressListener;
import com.sap.cloud.commercial.account.ops.commands.clone.CloneConfigurationsStateClient;
import com.sap.cloud.commercial.account.ops.utils.CisCmdLogging;
import com.sap.cloud.commercial.account.ops.utils.HttpClientUtils;
import com.sap.cloud.commercial.account.ops.utils.JsonUtils;
import com.sap.cloud.commercial.account.ops.utils.ResponseBuilderUtils;
import com.sap.cloud.commercial.account.ops.utils.sibling.CloneParameterParser;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.progress.ProgressMonitor;
import com.sap.jpaas.infrastructure.console.progress.Spinner;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Creates a new account for the customer associated with the given account. The user you specify must belong to this account and is assigned as a member of the newly created account")
public class CreateSiblingAccountsCommand
extends AccountOperationsAbstractCommand {
    private static final TimeUnit DEFAULT_TIMEUNIT_MILLIS = TimeUnit.MILLISECONDS;
    private static Logger LOGGER = Logger.getLogger(CreateSiblingAccountsCommand.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final long SPINNER_INTERVAL_MILLIS = 3000L;
    private static final long PROGRESS_CHECK_INTERVAL_MILLIS = 5000L;
    private static final long PROGRESS_NOTIFIER_CHECK_INTERVAL_MILLIS = 30000L;
    private static final long PROGRESS_NOTIFICATION_TIMEOUT_MILLIS = 60000L;
    private static final long TIMEOUT_MILLIS = 1800000L;
    private static final String PARAM_DISPLAY_NAME = "display-name";
    private static final String PARAM_CLONE = "clone";
    private static final String REQUEST_QUERY_PARAM_CLONE = "clone";
    @Parameter(names={"-n", "--display-name"}, description="Initial display name of the newly created account", required=true, validateWith=EmptyParameterValueValidator.class)
    protected String displayName;
    @Parameter(names={"--clone"}, description="(Optional) A comma separated list of values - trust, members, destinations or all. Each value combination is acceptable, for example, trust,members or all. If specified, all the configurations of the passed type(s) will be cloned to the newly created account.\n    Tip: We recommend listing explicitly the required cloning options instead of using --clone all in automated scripts. This will ensure backward compatibility in case the available cloning options, enveloped by all, change in future releases", required=false, validateWith=CloneParameterValidator.class)
    protected String cloneConfigurationsTypes;
    protected Set<ConfigurationType> confTypesToClone;
    private long commandStartTimeMillis;
    private CisCmdLogging cisCmdLogging;
    private final ProgressMonitor monitor = new ProgressMonitor();

    @Override
    public void init() {
        super.init();
        if (this.cloningConfigurations()) {
            this.confTypesToClone = CloneParameterParser.parseToOrderedSet(this.cloneConfigurationsTypes);
        }
    }

    @Override
    public String getName() {
        return "create-account";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void executeCommand(HttpClient httpClient) {
        try {
            this.commandStartTimeMillis = System.currentTimeMillis();
            this.dumpProcessingMessage();
            this.monitor.scheduleWithFixedDelay(new CommandExecutionProgressNotifier(this.commandStartTimeMillis), 30000L, 30000L, DEFAULT_TIMEUNIT_MILLIS);
            this.monitor.scheduleWithFixedDelay(new Spinner(new char[]{'.'}, false), 3000L, 3000L, DEFAULT_TIMEUNIT_MILLIS);
            this.executeCreateAccountWithOptionalConfiguirationsClone(httpClient);
        }
        catch (ClientProtocolException e) {
            this.getLogger().error(this.messages.getMessage("error.frontend"), e);
            throw new FrontendException(e, 166);
        }
        catch (IOException e) {
            this.getCisCmdLogging().logErrorThrowGenericErrorCommandException(this.getLogger(), e);
        }
        catch (URISyntaxException e) {
            this.getCisCmdLogging().logErrorThrowGenericErrorCommandException(this.getLogger(), e);
        }
    }

    @Override
    protected void handleOKResponse(HttpResponse httpResponse) throws IOException {
        HttpEntity httpReponseEntity = httpResponse.getEntity();
        if (httpReponseEntity != null) {
            JsonElement jsonFromEntity = JsonUtils.getJsonFromEntity(httpReponseEntity);
            if (this.cloningConfigurations()) {
                AccountCreatedCloneConfWrapperDTO wrapper = JsonUtils.convertJsonToObject(jsonFromEntity, AccountCreatedCloneConfWrapperDTO.class);
                this.dumpAccountCreatedWaitForFinalCloneState(wrapper);
            } else {
                Account createdAccount = JsonUtils.convertJsonToObject(jsonFromEntity, Account.class);
                this.dumpProcessingCompleted();
                this.dumpAccountCreated(createdAccount);
            }
        }
    }

    @Override
    protected String getMessageGroup() {
        return "create";
    }

    @Override
    protected String getUrl() {
        return this.getHost() + String.format("/services/%s/instances/%s/cisaccounts/%s/accounts/siblings", this.tunnelVersion, this.getAccount(), this.cisPublicRestVersion);
    }

    protected String getCloneOperationsStatusUrl(String account) {
        return this.getHost() + String.format("/services/%s/instances/%s/cisaccounts/%s/operations/clone-conf/state", this.tunnelVersion, account, this.cisPublicRestVersion);
    }

    @Override
    protected String getAdditionalDetailsToDisplay() {
        if (this.cloningConfigurations()) {
            StringBuilder sb = new StringBuilder();
            sb.append(NEW_LINE);
            sb.append(this.messages.getMessage("clone.requested"));
            sb.append(NEW_LINE);
            for (ConfigurationType t : this.confTypesToClone) {
                sb.append(String.format("  %s", new Object[]{t}));
                sb.append(NEW_LINE);
            }
            return sb.toString();
        }
        return null;
    }

    protected CloneConfigurationsStateClient getCloneConfigurationsStateClient(URI stateURI) {
        return new CloneConfigurationsStateClient(this.httpClient, stateURI, this.messages);
    }

    protected CisCmdLogging getCisCmdLogging() {
        if (this.cisCmdLogging == null) {
            this.cisCmdLogging = new CisCmdLogging(this.messages);
        }
        return this.cisCmdLogging;
    }

    protected long getProgressTimeoutMillis() {
        return 1800000L;
    }

    protected long getProgressCheckIntervalMillis() {
        return 5000L;
    }

    private boolean cloningConfigurations() {
        return this.cloneConfigurationsTypes != null && !this.cloneConfigurationsTypes.isEmpty();
    }

    private void executeCreateAccountWithOptionalConfiguirationsClone(HttpClient httpClient) throws IOException, URISyntaxException {
        Account accountToCreate = new Account();
        accountToCreate.setDisplayName(this.displayName);
        HttpPost httpPost = this.generateHttpPostRequest();
        String entityContent = JsonUtils.convertObjectToJson(accountToCreate, Account.class);
        HttpEntity entityToSend = HttpClientUtils.buildJsonHttpEntity(entityContent);
        httpPost.setEntity(entityToSend);
        HttpResponse requestResponse = httpClient.execute(httpPost);
        if (this.cloningConfigurations()) {
            this.handleResponse(requestResponse, 202);
        } else {
            this.handleResponse(requestResponse, 201);
        }
    }

    private HttpPost generateHttpPostRequest() throws URISyntaxException {
        HttpPost httpPost = new HttpPost(this.getUrl());
        if (this.cloningConfigurations()) {
            URIBuilder uriBuilder = new URIBuilder(httpPost.getURI());
            for (ConfigurationType t : this.confTypesToClone) {
                uriBuilder.addParameter("clone", t.toString());
            }
            httpPost.setURI(uriBuilder.build());
        }
        return httpPost;
    }

    private void dumpProcessingMessage() {
        System.out.print(NEW_LINE + this.messages.getMessage("clone.progress.started", new Date()));
    }

    private void dumpProcessingCompleted() {
        DumpHelper.dumpWithNewLine(this.messages.getMessage("clone.progress.completed", new Date(), System.currentTimeMillis() - this.commandStartTimeMillis));
    }

    private void dumpAccountCreated(Account createdAccount) {
        String msg = this.messages.getMessage("success.message", createdAccount.getName(), createdAccount.getDisplayName());
        DumpHelper.dumpWithNewLine(msg);
    }

    private void dumpAccountCreatedWaitForFinalCloneState(AccountCreatedCloneConfWrapperDTO wrapper) {
        URI statusURI = null;
        try {
            statusURI = new URI(this.getCloneOperationsStatusUrl(wrapper.getAccount().getName()));
        }
        catch (RuntimeException e) {
            this.getCisCmdLogging().logErrorThrowGenericErrorCommandException(this.getLogger(), new CommandException("Internal error! Could not determine clone operations status endpoint!", e));
        }
        catch (URISyntaxException e) {
            this.getCisCmdLogging().logErrorThrowGenericErrorCommandException(this.getLogger(), new CommandException("Internal error! Could not determine clone operations status endpoint!", e));
        }
        CloneConfigurationsStateClient client = this.getCloneConfigurationsStateClient(statusURI);
        AccountCreatedCloneConfWrapperDTO currentState = client.retrieveCurrentState();
        if (client.isStateFinal(currentState)) {
            this.dumpProcessingCompleted();
            this.dumpAccountCreated(wrapper.getAccount());
            this.dumpCloneState(currentState.getCloneStates());
            return;
        }
        DumpHelper.dump("");
        this.dumpAccountCreated(wrapper.getAccount());
        this.dumpProcessingMessage();
        AccountCreatedCloneConfWrapperDTO stateResultWrapper = this.waitForFinalCloneState(client);
        if (this.monitor.isTimedOut()) {
            DumpHelper.dumpWithNewLine(this.messages.getMessage("clone.progress.timeout", new Date(), this.getProgressTimeoutMillis()));
            if (stateResultWrapper != null && !stateResultWrapper.getCloneStates().isEmpty()) {
                this.dumpCloneState(stateResultWrapper.getCloneStates());
            }
            String message = this.messages.getMessage("clone.error.timeout", this.getProgressTimeoutMillis());
            this.getLogger().error(message);
            throw new CommandException(message);
        }
        this.dumpProcessingCompleted();
        this.dumpCloneState(stateResultWrapper.getCloneStates());
    }

    private void dumpCloneState(List<CloneOperationStateDetails> finalStates) {
        DumpHelper.dumpWithNewLine(this.messages.getMessage("clone.status", this.generateCloneStatesOutput(finalStates)));
    }

    private String generateCloneStatesOutput(List<CloneOperationStateDetails> states) {
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        for (CloneOperationStateDetails state : states) {
            keyValueMap.put(state.getConfigurationType().toString(), state.getState().toString());
        }
        return ResponseBuilderUtils.buildTableFormattedOutputStartingWithNewLine(keyValueMap);
    }

    private AccountCreatedCloneConfWrapperDTO waitForFinalCloneState(CloneConfigurationsStateClient client) {
        CloneConfigurationsProgressListener listener = new CloneConfigurationsProgressListener(client, this.monitor, this.messages);
        ScheduledFuture progressHandler = this.monitor.startProgress(listener, this.getProgressCheckIntervalMillis(), this.getProgressCheckIntervalMillis(), this.getProgressTimeoutMillis(), 60000L, DEFAULT_TIMEUNIT_MILLIS);
        this.monitor.waitFor(progressHandler);
        return (AccountCreatedCloneConfWrapperDTO)listener.getStatusCheck();
    }

    private class CommandExecutionProgressNotifier
    implements Runnable {
        private final long startTimeMillis;
        private long elapsedMinutesLog = 1L;

        public CommandExecutionProgressNotifier(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }

        @Override
        public void run() {
            long elapsedSeconds = (System.currentTimeMillis() - this.startTimeMillis) / 1000L;
            if (0L < elapsedSeconds && elapsedSeconds < 60L) {
                System.out.print(CreateSiblingAccountsCommand.this.messages.getMessage("clone.progress.notify.working"));
            } else if (60L <= elapsedSeconds && elapsedSeconds < 90L) {
                System.out.print(CreateSiblingAccountsCommand.this.messages.getMessage("clone.progress.notify.still.working"));
            }
            long elapsedMinutes = elapsedSeconds / 60L;
            if (this.elapsedMinutesLog < elapsedMinutes) {
                this.elapsedMinutesLog = elapsedMinutes;
                System.out.print(CreateSiblingAccountsCommand.this.messages.getMessage("clone.progress.notify.elapsed.minutes", this.elapsedMinutesLog));
            }
            CreateSiblingAccountsCommand.this.dumpProcessingMessage();
        }
    }
}

