/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.account.ops.entites.DbmsForAccount;
import com.sap.cloud.account.ops.entites.SchemasForAccount;
import com.sap.cloud.account.ops.entites.Subscription;
import com.sap.cloud.account.ops.exceptions.UnexpectedRESTResultException;
import com.sap.cloud.commercial.account.ops.commands.AccountOperationsWithHeaderProcessingCommand;
import com.sap.cloud.commercial.account.ops.utils.HttpClientUtils;
import com.sap.core.utils.infrastructure.validation.AuthenticationException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Deletes the account specified by the user. Only the user who has created the account is allowed to delete it")
public class DeleteSiblingAccountCommand
extends AccountOperationsWithHeaderProcessingCommand {
    private static final String SERVICES_FROM_URL = "services.";
    private static final String ERROR_IN_JSON_RESPONSE_PARSING_SUBSCRIPTIONS = "Unable to parse the JSON response from Subscription API. JSON extracted form the response body is: ";
    private static final String ERROR_IN_JSON_RESPONSE_PARSING_HTML5APPS = "Unable to parse the JSON response from dispachers HTML5Aps API. JSON extracted form the response body is: ";
    private static final String SUBSCRIPTION_APPLICATION_PROVIDER_DELIMITER = ":";
    private static final String SUBSCRIPTIONS_DELIMITER = ";";
    private static final String SHARED_ALIAS = "<shared>";
    private static Logger LOGGER = Logger.getLogger(DeleteSiblingAccountCommand.class);
    private static final String FIELDINFO_DELETE_SIBLING_ACCOUNT = "deleteSiblingAccount";
    private static final String HIDDEN_SUBSCRIPTIONS = "hidden.subscriptions";

    @Override
    public String getName() {
        return "delete-account";
    }

    @Override
    protected void executeCommand(HttpClient httpClient) {
        try {
            this.checkAccountForProductiveHana();
            this.checkForAccountSchemas();
            Set<Subscription> subscriptions = this.getAccountSubscriptions();
            this.checkForSubscribedApplications(subscriptions);
            if (this.isThereDispatcherSubscription(subscriptions).booleanValue()) {
                this.checkForHTML5Applications();
            }
            this.deleteSiblingAccount(httpClient);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to delete sibling account", e);
            String msg = this.messages.getGeneralMessage("unknown.problem");
            throw new CommandException(msg, 169);
        }
        finally {
            this.cleanup();
        }
    }

    private Boolean isThereDispatcherSubscription(Set<Subscription> subscriptions) {
        Subscription dispatcherSubscription = new Subscription("services", "dispatcher");
        for (Subscription subcription : subscriptions) {
            if (!dispatcherSubscription.equals(subcription)) continue;
            return true;
        }
        return false;
    }

    private Set<Subscription> getAccountSubscriptions() throws UnsupportedEncodingException, IOException, ClientProtocolException {
        JsonElement querySubscriptions = null;
        try {
            String subscriptionsAPIUrl = this.getSubscriptionAPIUrl();
            querySubscriptions = (JsonElement)HttpClientUtils.executeQuery(HttpClientUtils.HTTPMethod.GET, subscriptionsAPIUrl, null, Arrays.asList(200), null, this.httpClient, JsonElement.class);
        }
        catch (UnexpectedRESTResultException e) {
            this.handleErrorResponse(e.getStatusCode(), e.getResponse());
        }
        return this.buildSubscriptions(querySubscriptions);
    }

    @Override
    protected void handleOKResponse(HttpResponse httpResponse) throws IOException {
        String msg = this.messages.getMessage("success.message", this.getAccount());
        DumpHelper.dumpWithNewLine(msg);
    }

    private void deleteSiblingAccount(HttpClient httpClient) throws IOException {
        String url = this.getUrl();
        try {
            HttpClientUtils.executeQuery(HttpClientUtils.HTTPMethod.DELETE, url, null, Arrays.asList(200), null, httpClient, null);
            this.handleOKResponse(null);
        }
        catch (UnexpectedRESTResultException e) {
            this.handleErrorResponse(e.getStatusCode(), e.getResponse());
        }
    }

    private void checkAccountForProductiveHana() throws IOException {
        String persistenceAPIEndpoint = this.getPersistenceAPIUrl("dbms");
        try {
            Type type = new TypeToken<List<DbmsForAccount>>(){}.getType();
            List queryResult = (List)HttpClientUtils.executeQuery(HttpClientUtils.HTTPMethod.GET, persistenceAPIEndpoint, null, Arrays.asList(200), null, this.httpClient, type);
            for (DbmsForAccount dbmsForAccount : queryResult) {
                if (SHARED_ALIAS.equals(dbmsForAccount.getDbAliasName())) continue;
                throw new BackendException(this.messages.getMessage("persistence.dbms.exists", dbmsForAccount.getDbAliasName(), this.getAccount()), 169);
            }
        }
        catch (UnexpectedRESTResultException e) {
            this.handlePersistenceApiError(e.getStatusCode(), "persistence.dbms.error");
        }
    }

    private void checkForAccountSchemas() throws IOException {
        String persistenceAPIEndpoint = this.getPersistenceAPIUrl("schemas");
        try {
            SchemasForAccount queryResult = (SchemasForAccount)HttpClientUtils.executeQuery(HttpClientUtils.HTTPMethod.GET, persistenceAPIEndpoint, null, Arrays.asList(200), null, this.httpClient, SchemasForAccount.class);
            this.handlePersistenceAPIResponse(queryResult);
        }
        catch (UnexpectedRESTResultException e) {
            this.handlePersistenceApiError(e.getStatusCode(), "persistence.api.error");
        }
    }

    private void checkForHTML5Applications() throws IOException {
        try {
            JsonArray queryResult = (JsonArray)HttpClientUtils.executeQueryBasicAuthentication(HttpClientUtils.HTTPMethod.GET, this.getHTML5ApplicationAPIUrl(), null, Arrays.asList(200), null, this.getDispatcherHttpClient(), JsonArray.class, this.getUser(), this.getPassword());
            this.handleGetHTML5ApplicationsResponse(queryResult);
        }
        catch (AuthenticationException e) {
            throw new SecurityException(e.getMessage(), 111);
        }
        catch (UnexpectedRESTResultException e) {
            this.handleErrorResponse(e.getStatusCode(), e.getResponse());
        }
        catch (HostValidationException e) {
            throw new BackendException(e);
        }
    }

    protected HttpClient getDispatcherHttpClient() throws HostValidationException, AuthenticationException, IOException {
        URL dispatcherURL = new URL(this.getHost());
        return LandscapeHostValidator.getHttpClient(new URL(String.format("https://dispatcher.%s", dispatcherURL.getHost().substring(SERVICES_FROM_URL.length()))), "/hcproxy/b/api/", 2000, true);
    }

    private void handlePersistenceAPIResponse(SchemasForAccount result) throws IOException {
        if (result == null) {
            LOGGER.debug("No proper JSON response from Persistance API. (allAccountSchemasJson == null || allAccountSchemas == null)");
            throw new BackendException(this.messages.getMessage("persistence.api.error", this.getAccount()), 169);
        }
        if (result.getSchemas().length > 0) {
            LOGGER.debug("Schemas returned by Persistance API: " + Arrays.toString(result.getSchemas()));
            throw new BackendException(this.messages.getMessage("persistence.schemas.exist", this.getAccount()), 169);
        }
    }

    protected void handlePersistenceApiError(int status, String internalErrorKey) {
        LOGGER.debug("Persistence API returning status code: " + status);
        switch (status) {
            case 401: 
            case 403: {
                LOGGER.error(this.messages.getMessage("401"));
                throw new SecurityException(this.messages.getMessage("401", this.getAccount()), 111);
            }
            case 400: 
            case 404: 
            case 409: 
            case 500: {
                LOGGER.error(this.messages.getMessage(internalErrorKey, this.getAccount()));
                throw new BackendException(this.messages.getMessage(internalErrorKey, this.getAccount()), 210);
            }
        }
        throw new CommandException(this.messages.getGeneralMessage("unknown.http.error", status), 169);
    }

    protected String getPersistenceAPIUrl(String service) {
        return this.getHost() + String.format("/services/%s/instances/%s/persistence/%s/%s/", this.tunnelVersion, this.getAccount(), this.persistanceAPIVersion, service);
    }

    private void checkForSubscribedApplications(Set<Subscription> subscriptions) throws IOException {
        if (!this.areHiddenSubscriptionsOnlyAvailable(subscriptions) && subscriptions.size() > 0) {
            LOGGER.debug("There are still subscription returned by Subscription API: " + subscriptions);
            throw new BackendException(this.messages.getMessage("subscriptions.exist", this.getAccount()), 169);
        }
        LOGGER.info("Account " + this.getAccount() + " with subscriptions " + subscriptions + " will be deleted.");
        LOGGER.debug("Check successful, the account is not subscribed to any application.");
    }

    private void handleGetHTML5ApplicationsResponse(JsonArray result) throws IOException {
        if (result == null) {
            this.throwBackendException(result, ERROR_IN_JSON_RESPONSE_PARSING_HTML5APPS, "subscriptions.exist");
        }
        if (result.size() > 0) {
            LOGGER.debug("There are still HTML5 applications in account " + this.getAccount() + ".");
            throw new BackendException(this.messages.getMessage("html5application.exist", this.getAccount()), 169);
        }
        LOGGER.info("Account " + this.getAccount() + " will be deleted.");
        LOGGER.debug("Check successful, the account does not contain any HTML5 applications.");
    }

    private boolean areHiddenSubscriptionsOnlyAvailable(Set<Subscription> subscriptions) {
        return this.getHiddenSubscriptions().containsAll(subscriptions);
    }

    private Set<Subscription> getHiddenSubscriptions() {
        String[] subscriptions;
        HashSet<Subscription> result = new HashSet<Subscription>();
        for (String subscription : subscriptions = this.paramsBundle.getString(HIDDEN_SUBSCRIPTIONS).split(SUBSCRIPTIONS_DELIMITER)) {
            String[] values = subscription.split(SUBSCRIPTION_APPLICATION_PROVIDER_DELIMITER);
            result.add(new Subscription(values[0], values[1]));
        }
        return result;
    }

    private HashSet<Subscription> buildSubscriptions(JsonElement result) throws IOException {
        Subscription[] subscriptionsArray;
        JsonObject elements;
        if (result == null) {
            this.throwBackendException(result, ERROR_IN_JSON_RESPONSE_PARSING_SUBSCRIPTIONS, "subscription.api.error");
        }
        if ((elements = result.getAsJsonObject()) == null) {
            this.throwBackendException(result, ERROR_IN_JSON_RESPONSE_PARSING_SUBSCRIPTIONS, "subscription.api.error");
        }
        if ((subscriptionsArray = new Gson().fromJson(elements.get("subscriptions"), Subscription[].class)) == null) {
            this.throwBackendException(result, ERROR_IN_JSON_RESPONSE_PARSING_SUBSCRIPTIONS, "subscription.api.error");
        }
        return new HashSet<Subscription>(Arrays.asList(subscriptionsArray));
    }

    private void throwBackendException(JsonElement jsonFromEntity, String errorInParsingMessge, String messageKey) {
        LOGGER.debug(errorInParsingMessge + jsonFromEntity);
        throw new BackendException(this.messages.getMessage(messageKey, this.getAccount()), 169);
    }

    protected String getSubscriptionAPIUrl() {
        return this.getHost() + String.format("/services/%s/instances/%s/subscriptions/%s/", this.tunnelVersion, this.getAccount(), this.subscriptionsAPIVersion);
    }

    protected String getHTML5ApplicationAPIUrl() throws MalformedURLException {
        URL url = new URL(this.getHost());
        return String.format("https://dispatcher.%s/hcproxy/b/api/accounts/%s/applications", url.getHost().substring(SERVICES_FROM_URL.length()), this.getAccount());
    }

    @Override
    protected String getUrl() {
        return this.getHost() + String.format("/services/%s/instances/%s/accounts/%s/accounts/siblings", this.tunnelVersion, this.getAccount(), this.domainDbPublicRestVersion);
    }

    @Override
    protected String getMessageGroup() {
        return "delete";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void processHeadersFromErrorMessage(HttpResponse response) {
        Header fieldinfoHeader;
        if (response != null && this.headerHasErrorMessages(fieldinfoHeader = response.getLastHeader("x-systemdb-fieldinfo")) && fieldinfoHeader.getValue().equals(FIELDINFO_DELETE_SIBLING_ACCOUNT)) {
            Header errorHeader = response.getLastHeader("x-systemdb-errormsg");
            if (this.headerHasErrorMessages(errorHeader)) {
                LOGGER.error(errorHeader.getValue());
            }
            throw new SecurityException(this.messages.getMessage("401"), 169);
        }
    }
}

