/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.sap.cloud.account.ops.entites.Account;
import com.sap.cloud.account.ops.entites.Quota;
import com.sap.cloud.commercial.account.ops.commands.AccountOperationsWithQuotaManipulationCommand;
import com.sap.cloud.commercial.account.ops.utils.JsonUtils;
import com.sap.cloud.commercial.account.ops.utils.ResponseBuilderUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Lists all accounts for the customer associated with the given account. The user you specify must be a member of this account")
public class ListSiblingAccountsCommand
extends AccountOperationsWithQuotaManipulationCommand {
    private static Logger LOGGER = Logger.getLogger(ListSiblingAccountsCommand.class);

    @Override
    public String getName() {
        return "list-accounts";
    }

    @Override
    protected void executeCommand(HttpClient httpClient) {
        try {
            this.getAllSiblingAccounts(httpClient);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to list sibling accounts", e);
            String msg = this.messages.getGeneralMessage("unknown.problem");
            throw new CommandException(msg, 169);
        }
        finally {
            this.cleanup();
        }
    }

    private void getAllSiblingAccounts(HttpClient httpClient) throws IOException {
        String url = this.getUrl();
        HttpGet httpGet = new HttpGet(url);
        HttpResponse execute = httpClient.execute(httpGet);
        this.handleResponse(execute, 200);
    }

    @Override
    protected String getMessageGroup() {
        return "list";
    }

    @Override
    protected void handleOKResponse(HttpResponse httpResponse) throws IOException {
        List<Quota> listOfQuotas = this.getListOfQuotas("/services/%s/instances/%s/accounts/%s/quotas");
        String listAccountsMsg = this.buildAccountsSectionMessage(httpResponse.getEntity(), listOfQuotas);
        listAccountsMsg = listAccountsMsg + this.buildGlobalAndFreeQuotasMessage(listOfQuotas);
        DumpHelper.dumpWithNewLine(listAccountsMsg);
    }

    @Override
    protected String getUrl() {
        return this.getHost() + String.format("/services/%s/instances/%s/accounts/%s/accounts/siblings", this.tunnelVersion, this.getAccount(), this.domainDbPublicRestVersion);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    private String buildAccountsSectionMessage(HttpEntity entity, List<Quota> listOfQuotas) throws IOException {
        JsonArray allSiblingAccountsJson = JsonUtils.getJsonFromEntity(entity).getAsJsonArray();
        List<Account> allSiblingAccounts = JsonUtils.convertJsonArrayToListOfObjects(allSiblingAccountsJson, Account.class);
        if (listOfQuotas != null) {
            for (Account account : allSiblingAccounts) {
                this.mergeAccountsWithQuotas(account, listOfQuotas);
            }
        }
        return ResponseBuilderUtils.buildBlockResponse("accounts", allSiblingAccounts, this.messages, "accounts.name", "accounts.displayName", "accounts.creationTime", "compute.unit.quota");
    }

    private void mergeAccountsWithQuotas(Account account, List<Quota> listOfQuotas) {
        for (Quota quota : listOfQuotas) {
            if (!account.equals(quota.getAccount())) continue;
            quota.setAccount(null);
            account.addAssignedQuotas(quota);
        }
    }
}

