/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.account.ops.converters.QuotaAmountConverter;
import com.sap.cloud.account.ops.entites.Account;
import com.sap.cloud.account.ops.entites.Quota;
import com.sap.cloud.account.ops.entites.QuotaType;
import com.sap.cloud.account.ops.validators.QuotaComplexInputValidator;
import com.sap.cloud.commercial.account.ops.commands.AccountOperationsWithHeaderProcessingCommand;
import com.sap.cloud.commercial.account.ops.utils.HttpClientUtils;
import com.sap.cloud.commercial.account.ops.utils.JsonUtils;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Sets compute unit quotas for a given account")
public class SetQuotaCommand
extends AccountOperationsWithHeaderProcessingCommand {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HEADER_SUM_EXCEEDS_QUOTA = "sumExceedsGlobalQuota";
    private static final String HEADER_EXCEEDS_QUOTA = "requestedAmountExceedsGlobalQuota";
    private static final String HEADER_DECREASE_RUNNING_VMS_QUOTA = "addDecreaseQuota";
    private static final String QUOTA_REQUEST_DETAILS = "quotaRequestDetails";
    private static final String VM_SIZE = "vmSize";
    private static final String RUNNING_AMOUNT = "runningAmount";
    private static Logger LOGGER = Logger.getLogger(SetQuotaCommand.class);
    private static final String CODE_PREFIX = "code.";
    @Parameter(names={"-m", "--amount"}, description="Quota size: lite:<amount>, pro:<amount>, prem:<amount>, prem-plus:<amount>", validateWith=QuotaComplexInputValidator.class, required=true, converter=QuotaAmountConverter.class)
    private Quota quota;

    @Override
    protected void executeCommand(HttpClient httpClient) {
        try {
            this.setQuota(httpClient);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to set account quota", e);
            String msg = this.messages.getGeneralMessage("unknown.problem");
            throw new CommandException(msg, 169);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected Map<String, String> getAdditionalParametersToDisplay() {
        HashMap<String, String> additionalParametersToDisplay = new HashMap<String, String>();
        additionalParametersToDisplay.put("quota type", this.paramsBundle.getString(CODE_PREFIX + this.quota.getQuotaType().getCode()));
        additionalParametersToDisplay.put("quota amount", this.quota.getAmount().toString());
        return additionalParametersToDisplay;
    }

    private void setQuota(HttpClient httpClient) throws IOException {
        HttpPut httpPut = new HttpPut(this.getUrl());
        Account account = new Account();
        account.setName(this.getAccount());
        this.quota.setAccount(account);
        String content = JsonUtils.convertObjectToJson(this.quota, Quota.class);
        HttpEntity entity = HttpClientUtils.buildJsonHttpEntity(content);
        httpPut.setEntity(entity);
        HttpResponse response = httpClient.execute(httpPut);
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 200: {
                this.handleOKResponse(response);
                break;
            }
            default: {
                this.handleErrorResponse(statusCode, response);
            }
        }
    }

    @Override
    protected void handleOKResponse(HttpResponse httpResponse) throws IOException {
        String msg = this.messages.getMessage("success.message", this.paramsBundle.getString(CODE_PREFIX + this.quota.getQuotaType().getCode()), this.quota.getAmount(), this.getAccount());
        DumpHelper.dumpWithNewLine(msg);
    }

    @Override
    protected String getMessageGroup() {
        return "setquota";
    }

    @Override
    protected String getUrl() {
        return this.getHost() + String.format("/services/%s/instances/%s/accounts/%s/quotas/quota", this.tunnelVersion, this.getAccount(), this.domainDbPublicRestVersion);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "set-quota";
    }

    @Override
    public void processHeadersFromErrorMessage(HttpResponse response) {
        Header fieldinfoHeader = response.getLastHeader("x-systemdb-fieldinfo");
        if (this.headerHasErrorMessages(fieldinfoHeader)) {
            String fieldInfoHeaderString = fieldinfoHeader.getValue();
            Header errorHeader = response.getLastHeader("x-systemdb-errormsg");
            if (this.headerHasErrorMessages(errorHeader)) {
                if (HEADER_EXCEEDS_QUOTA.equals(fieldInfoHeaderString) || HEADER_SUM_EXCEEDS_QUOTA.equals(fieldInfoHeaderString)) {
                    this.handleExceededQuota(errorHeader);
                } else if (HEADER_DECREASE_RUNNING_VMS_QUOTA.equals(fieldInfoHeaderString)) {
                    this.handleDecreasedRunningQuota(response.getEntity(), errorHeader);
                } else {
                    LOGGER.debug("No explicit handling is defined for fieldInfoHeader: " + fieldInfoHeaderString + " and ErrorHeaderValue: " + errorHeader.getValue());
                }
            }
        }
    }

    private void handleDecreasedRunningQuota(HttpEntity entity, Header errorHeader) {
        LOGGER.debug(errorHeader.getValue());
        try {
            JsonElement quotaAmountValidation = JsonUtils.getJsonFromEntity(entity);
            if (quotaAmountValidation != null) {
                this.parseDecreasedRunningQuotaJsonResponse(quotaAmountValidation);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to retrieve the expected JSON response from the HTTP Response.", e);
            throw new BackendException(this.messages.getMessage("parse.json.response.error", this.account), 169);
        }
    }

    private void parseDecreasedRunningQuotaJsonResponse(JsonElement quotaAmountValidation) {
        JsonObject quotaAmountValidationJsObj = quotaAmountValidation.getAsJsonObject();
        JsonArray quotaRequestDetailsJsonArray = quotaAmountValidationJsObj.getAsJsonArray(QUOTA_REQUEST_DETAILS);
        if (quotaRequestDetailsJsonArray != null) {
            StringBuilder requestedSizes = new StringBuilder();
            StringBuilder runningProcessesCountMessage = new StringBuilder();
            this.processRequestDetails(quotaRequestDetailsJsonArray, requestedSizes, runningProcessesCountMessage);
            StringBuilder errMsg = this.formatDecreaseQuotaMessage(requestedSizes, runningProcessesCountMessage);
            throw new BackendException(errMsg.toString(), 168);
        }
    }

    private void processRequestDetails(JsonArray quotaRequestDetailsJsonArray, StringBuilder requestedSizes, StringBuilder runningProcessesCountMessage) {
        Iterator<JsonElement> it = quotaRequestDetailsJsonArray.iterator();
        while (it.hasNext()) {
            JsonElement quotaRequestDetailsElement = it.next();
            String vmSize = this.extractElement(quotaRequestDetailsElement, VM_SIZE);
            String externalizedVmSize = this.messages.getMessage(vmSize);
            requestedSizes.append(externalizedVmSize);
            String runningAmount = this.extractElement(quotaRequestDetailsElement, RUNNING_AMOUNT);
            runningProcessesCountMessage.append(this.messages.getMessage("decreased.running", runningAmount, externalizedVmSize));
            if (it.hasNext()) {
                requestedSizes.append(", ");
            }
            runningProcessesCountMessage.append(LINE_SEPARATOR);
        }
    }

    private String extractElement(JsonElement quotaRequestDetailsElement, String elementName) {
        JsonElement elementNameJson = quotaRequestDetailsElement.getAsJsonObject().get(elementName);
        if (elementNameJson != null) {
            return elementNameJson.getAsString();
        }
        throw new BackendException(this.messages.getMessage("parse.json.response.error", this.account), 169);
    }

    private StringBuilder formatDecreaseQuotaMessage(StringBuilder requestedSizes, StringBuilder runningProcessesCountMessage) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(this.messages.getMessage("decreased.sizes", requestedSizes));
        errMsg.append(LINE_SEPARATOR);
        errMsg.append((CharSequence)runningProcessesCountMessage);
        errMsg.append(this.messages.getMessage("decreased.hint", this.getAccount()));
        return errMsg;
    }

    private void handleExceededQuota(Header errorHeader) {
        LOGGER.error(errorHeader.getValue());
        String[] quotaValue = this.parseErrorHeader(errorHeader.getValue());
        String table = this.buildTableWithGlobalAndFreeQuotas();
        if (quotaValue != null) {
            String purchasedAmount = quotaValue[2];
            String msg = "";
            msg = this.messages.getMessage("total.exceeds", this.quota.getAmount(), purchasedAmount);
            throw new BackendException(msg + "\n\n" + table + "\n", 168);
        }
        throw new BackendException(this.messages.getMessage(409) + "\n\n" + table + "\n", 168);
    }

    private String buildTableWithGlobalAndFreeQuotas() {
        List<Quota> listOfQuotas = this.getListOfQuotas("/services/%s/instances/%s/accounts/%s/quotas");
        return this.buildGlobalAndFreeQuotasMessage(listOfQuotas);
    }

    private String[] parseErrorHeader(String headerValue) {
        String[] splited = headerValue.split(";");
        if (splited.length != 3) {
            return null;
        }
        String[] toReturn = new String[3];
        for (int i = 0; i < splited.length; ++i) {
            String val;
            toReturn[i] = val = splited[i].split(":")[1];
        }
        return toReturn;
    }

    protected void setSize(String size) {
        this.quota.getQuotaType().setCode(size);
    }

    protected void setAmount(long amount) {
        this.quota.setAmount(new BigDecimal(amount));
    }

    protected void initQuota() {
        this.quota = new Quota();
        QuotaType quotaType = new QuotaType();
        this.quota.setQuotaType(quotaType);
    }
}

