/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands.clone;

import com.sap.cloud.account.ops.entites.AccountCreatedCloneConfWrapperDTO;
import com.sap.cloud.account.ops.i18n.CommandMessages;
import com.sap.cloud.commercial.account.ops.commands.clone.CloneConfigurationsStateClient;
import com.sap.cloud.commercial.account.ops.utils.CisCmdLogging;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.progress.ProgressListener;
import com.sap.jpaas.infrastructure.console.progress.ProgressMonitor;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.apache.log4j.Logger;

public class CloneConfigurationsProgressListener
extends ProgressListener<CloneConfigurationsStateClient, AccountCreatedCloneConfWrapperDTO> {
    private static Logger LOGGER = Logger.getLogger(CloneConfigurationsProgressListener.class);
    private final ProgressMonitor monitor;
    private final CisCmdLogging cisCmdLogging;

    public CloneConfigurationsProgressListener(CloneConfigurationsStateClient processor, ProgressMonitor monitor, CommandMessages messages) {
        super.setProcessor(processor);
        this.monitor = monitor;
        this.cisCmdLogging = new CisCmdLogging(messages);
    }

    @Override
    public boolean progressCheck(ScheduledFuture progressHandler) throws CommandException {
        AccountCreatedCloneConfWrapperDTO currentState = ((CloneConfigurationsStateClient)this.getProcessor()).retrieveCurrentState();
        this.setStatusCheck(currentState);
        return ((CloneConfigurationsStateClient)this.getProcessor()).isStateFinal(currentState);
    }

    @Override
    public void progressNotification() {
    }

    @Override
    public void finished() {
    }

    @Override
    public void failed() {
        this.cisCmdLogging.logErrorThrowGenericErrorCommandException(LOGGER, new CommandException(String.format("[%s] Clone operations progress check failed! Elapsed %d ms", new Date(), this.monitor.getElapsedTime())));
    }
}

