/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.commands.clone;

import com.google.gson.JsonElement;
import com.sap.cloud.account.ops.entites.AccountCreatedCloneConfWrapperDTO;
import com.sap.cloud.account.ops.entites.CloneOperationStateDetails;
import com.sap.cloud.account.ops.i18n.CommandMessages;
import com.sap.cloud.commercial.account.ops.utils.CisCmdLogging;
import com.sap.cloud.commercial.account.ops.utils.JsonUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class CloneConfigurationsStateClient {
    private static Logger LOGGER = Logger.getLogger(CloneConfigurationsStateClient.class);
    private final HttpClient httpClient;
    private final URI stateURI;
    private final CisCmdLogging cisCmdLogging;

    public CloneConfigurationsStateClient(HttpClient httpClient, URI stateURI, CommandMessages messages) {
        this.httpClient = httpClient;
        this.stateURI = stateURI;
        this.cisCmdLogging = new CisCmdLogging(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountCreatedCloneConfWrapperDTO retrieveCurrentState() {
        HttpResponse httpResponse = null;
        try {
            JsonElement jsonFromEntity;
            AccountCreatedCloneConfWrapperDTO wrapper;
            HttpGet request = new HttpGet(this.stateURI);
            httpResponse = this.httpClient.execute(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                this.cisCmdLogging.logErrorThrowGenericErrorCommandException(LOGGER, new CommandException(String.format("Unexpected response code [%d] while executing [%s] request to [%s]", statusCode, request.getMethod(), request.getURI())));
            }
            if ((wrapper = JsonUtils.convertJsonToObject(jsonFromEntity = JsonUtils.getJsonFromEntity(httpResponse.getEntity()), AccountCreatedCloneConfWrapperDTO.class)) == null || wrapper.getCloneStates().isEmpty()) {
                this.cisCmdLogging.logErrorThrowGenericErrorCommandException(LOGGER, new CommandException(String.format("Unexpected repsponse body JSON [%s] as a result from [%s] request to [%s] resulted in status code [%d]", jsonFromEntity, request.getMethod(), request.getURI(), statusCode)));
            }
            AccountCreatedCloneConfWrapperDTO accountCreatedCloneConfWrapperDTO = wrapper;
            return accountCreatedCloneConfWrapperDTO;
        }
        catch (ClientProtocolException e) {
            throw new FrontendException(e, 166);
        }
        catch (IOException e) {
            this.cisCmdLogging.logErrorThrowGenericErrorCommandException(LOGGER, e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    EntityUtils.consume(httpResponse.getEntity());
                }
                catch (IOException e) {
                    LOGGER.debug("Caught IOException while consuming response", e);
                }
            }
        }
        return null;
    }

    public boolean isStateFinal(AccountCreatedCloneConfWrapperDTO statesWrapper) {
        if (statesWrapper == null || statesWrapper.getCloneStates() == null || statesWrapper.getCloneStates().isEmpty()) {
            throw new IllegalArgumentException("Passed states object should not be null or holding empty state list.");
        }
        List<CloneOperationStateDetails> currentCloneStates = statesWrapper.getCloneStates();
        int finalStateCounter = 0;
        for (CloneOperationStateDetails stateDetails : currentCloneStates) {
            if (!stateDetails.getState().isFinal()) continue;
            ++finalStateCounter;
        }
        return finalStateCounter == currentCloneStates.size();
    }
}

