/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.utils;

import com.google.gson.JsonElement;
import com.sap.cloud.account.ops.exceptions.ErrorRESTResultException;
import com.sap.cloud.account.ops.exceptions.UnexpectedRESTResultException;
import com.sap.cloud.commercial.account.ops.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtils {
    private static Logger LOGGER = Logger.getLogger(HttpClientUtils.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String ERROR_MESSAGE_HEADER = "x-systemdb-errormsg";
    private static final String ERROR_FIELDINFO_HEADER = "x-systemdb-fieldinfo";

    public static HttpEntity buildJsonHttpEntity(String jsonContents) throws UnsupportedEncodingException {
        if (jsonContents != null) {
            StringEntity stringEntity = new StringEntity(jsonContents, "UTF-8");
            stringEntity.setContentType(APPLICATION_JSON);
            return stringEntity;
        }
        return null;
    }

    public static <T> T executeQuery(HTTPMethod method, String queryURL, Object body, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, HttpClient client, Type type) throws UnexpectedRESTResultException, UnsupportedEncodingException, IOException, ClientProtocolException {
        return HttpClientUtils.executeQueryWithHeaders(method, queryURL, body, expectedSuccessCodes, expectedErrorCodes, client, type, new Header[0]);
    }

    public static <T> T executeQueryWithHeaders(HTTPMethod method, String queryURL, Object body, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, HttpClient client, Type type, Header ... headers) throws UnexpectedRESTResultException, UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpRequestBase query = HttpClientUtils.prepareHttpRequest(method, queryURL, body, expectedSuccessCodes, expectedErrorCodes, client, headers);
        HttpResponse response = client.execute(query);
        return HttpClientUtils.handleRemoteCallResponse(response, expectedSuccessCodes, expectedErrorCodes, type);
    }

    public static <T> T executeQueryBasicAuthentication(HTTPMethod method, String queryURL, Object body, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, HttpClient client, Type type, String username, String password) throws UnexpectedRESTResultException, UnsupportedEncodingException, IOException, ClientProtocolException {
        return HttpClientUtils.executeQueryBasicAuthenticationWithHeaders(method, queryURL, body, expectedSuccessCodes, expectedErrorCodes, client, type, username, password, new Header[0]);
    }

    public static <T> T executeQueryBasicAuthenticationWithHeaders(HTTPMethod method, String queryURL, Object body, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, HttpClient client, Type type, String username, String password, Header ... headers) throws UnexpectedRESTResultException, UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpRequestBase query = HttpClientUtils.prepareHttpRequest(method, queryURL, body, expectedSuccessCodes, expectedErrorCodes, client, headers);
        URI uri = query.getURI();
        if (uri == null) {
            throw new IllegalArgumentException("null uri for query: " + query);
        }
        URL url = uri.toURL();
        HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        HttpClientContext context = HttpClientUtils.configurePreemptiveBasicAuthenticationContext(username, password, targetHost);
        HttpResponse response = client.execute((HttpUriRequest)query, context);
        return HttpClientUtils.handleRemoteCallResponse(response, expectedSuccessCodes, expectedErrorCodes, type);
    }

    private static StringBuilder extractErrorMsg(HttpResponse httpResponse) {
        Header fieldinfoHeader;
        StringBuilder errorMsg = new StringBuilder();
        Header errorHeader = httpResponse.getLastHeader(ERROR_MESSAGE_HEADER);
        if (HttpClientUtils.headerHasErrorMessages(errorHeader)) {
            errorMsg.append("Message: " + errorHeader.getValue() + ";");
        }
        if (HttpClientUtils.headerHasErrorMessages(fieldinfoHeader = httpResponse.getLastHeader(ERROR_FIELDINFO_HEADER))) {
            errorMsg.append(" Field info: " + fieldinfoHeader.getValue());
        }
        return errorMsg;
    }

    private static boolean headerHasErrorMessages(Header header) {
        return header != null && header.getValue() != null && !header.getValue().trim().isEmpty();
    }

    public static void releaseHttpClient(HttpClient httpClient) {
        if (httpClient != null && httpClient instanceof DefaultHttpClient) {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private static BasicHttpEntity createJsonEntity(Object body) throws UnsupportedEncodingException {
        String jsonString = body instanceof JsonElement ? body.toString() : JsonUtils.getGson().toJson(body, body.getClass());
        BasicHttpEntity basicHttpEntity = JsonUtils.createJSONHttpEntity(jsonString);
        basicHttpEntity.setContentType(APPLICATION_JSON);
        return basicHttpEntity;
    }

    private static HttpRequestBase prepareHttpRequest(HTTPMethod method, String queryURL, Object body, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, HttpClient client, Header ... headers) throws UnsupportedEncodingException {
        if (method == null || HttpClientUtils.isEmpty(queryURL) || expectedErrorCodes != null && expectedErrorCodes.size() == 0 || client == null) {
            throw new IllegalArgumentException(String.format("At least one of the arguments is null or empty. Http method: [%s], queryURL: [%s], expectedSuccessCodes [%s], Http Client: [%s]", new Object[]{method, queryURL, expectedSuccessCodes, client}));
        }
        HttpRequestBase query = HttpClientUtils.prepareHttpRequest(method, queryURL, body);
        for (Header header : headers) {
            query.addHeader(header);
        }
        return query;
    }

    private static HttpRequestBase prepareHttpRequest(HTTPMethod method, String queryURL, Object body) throws UnsupportedEncodingException {
        HttpRequestBase query = null;
        switch (method) {
            case GET: {
                query = new HttpGet(queryURL);
                break;
            }
            case POST: {
                query = new HttpPost(queryURL);
                break;
            }
            case PUT: {
                query = new HttpPut(queryURL);
                break;
            }
            case DELETE: {
                query = new HttpDelete(queryURL);
            }
        }
        if (query == null) {
            throw new IllegalArgumentException("null query for method: " + (Object)((Object)method));
        }
        if (body != null && method.supportsEnclosingRequest()) {
            if (body instanceof byte[]) {
                query.addHeader("Content-Type", APPLICATION_OCTET_STREAM);
                ByteArrayEntity byteEntity = new ByteArrayEntity((byte[])body);
                byteEntity.setContentType(APPLICATION_OCTET_STREAM);
                ((HttpEntityEnclosingRequestBase)query).setEntity(byteEntity);
            } else {
                query.addHeader("Content-Type", APPLICATION_JSON);
                BasicHttpEntity jsonEntity = HttpClientUtils.createJsonEntity(body);
                ((HttpEntityEnclosingRequestBase)query).setEntity(jsonEntity);
            }
        }
        return query;
    }

    private static HttpClientContext configurePreemptiveBasicAuthenticationContext(String username, String password, HttpHost targetHost) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), new UsernamePasswordCredentials(username, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(credsProvider);
        context.setAuthCache(authCache);
        return context;
    }

    private static <T> T handleRemoteCallResponse(HttpResponse response, List<Integer> expectedSuccessCodes, List<Integer> expectedErrorCodes, Type type) throws UnsupportedEncodingException, IllegalStateException, IOException, ErrorRESTResultException, UnexpectedRESTResultException {
        HttpEntity entity = response.getEntity();
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (expectedSuccessCodes.contains(statusCode)) {
                if (entity == null || type == null) {
                    T t = null;
                    return t;
                }
                Header securityLoginHeader = response.getFirstHeader("com.sap.cloud.security.login");
                if (securityLoginHeader != null) {
                    throw new IllegalStateException("Security Login problem: " + EntityUtils.toString(entity));
                }
                if (type == HttpResponse.class) {
                    HttpResponse httpResponse = response;
                    return (T)httpResponse;
                }
                if (type instanceof Class && JsonElement.class.isAssignableFrom((Class)type)) {
                    JsonElement parsedJson;
                    Header contentTypeHeader = response.getFirstHeader("Content-Type");
                    Header entityContentTypeHeader = entity.getContentType();
                    if (contentTypeHeader != null && !APPLICATION_JSON.equalsIgnoreCase(contentTypeHeader.getValue()) || entityContentTypeHeader != null && !APPLICATION_JSON.equalsIgnoreCase(entityContentTypeHeader.getValue())) {
                        LOGGER.warn("The content type of either response or entity is not application/json");
                    }
                    if ((parsedJson = JsonUtils.getJsonFromEntity(entity)).isJsonNull()) {
                        T t = null;
                        return t;
                    }
                    JsonElement jsonElement = parsedJson;
                    return (T)jsonElement;
                }
                Object contentTypeHeader = JsonUtils.getGson().fromJson((Reader)new InputStreamReader(entity.getContent(), "UTF-8"), type);
                return contentTypeHeader;
            }
            String headerErrMsg = HttpClientUtils.extractErrorMsg(response).toString();
            if (expectedErrorCodes != null && expectedErrorCodes.contains(statusCode)) {
                String errorMessage = String.format("Error during remote call. Status code [%d]. [%s]", statusCode, headerErrMsg);
                ErrorRESTResultException expectedError = new ErrorRESTResultException(errorMessage);
                throw expectedError;
            }
            String errorMessage = String.format("Unexpected error during remote call. Status code [%d]. [%s]", statusCode, headerErrMsg);
            UnexpectedRESTResultException unexpectedError = new UnexpectedRESTResultException(errorMessage, statusCode, response);
            throw unexpectedError;
        }
        finally {
            EntityUtils.consume(entity);
        }
    }

    private static boolean isEmpty(String toCheck) {
        return toCheck == null || toCheck.trim().length() == 0;
    }

    public static enum HTTPMethod {
        GET,
        POST,
        PUT,
        DELETE;


        public boolean supportsEnclosingRequest() {
            return this.equals((Object)POST) || this.equals((Object)PUT);
        }
    }
}

