/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BasicHttpEntity;

public class JsonUtils {
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    public static <T> List<T> convertJsonArrayToListOfObjects(JsonArray content, Class<T> type) throws IOException {
        if (content != null) {
            ArrayList<T> listToReturn = new ArrayList<T>();
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                JsonElement jsonElement = content.get(i);
                T convertJsonToObject = JsonUtils.convertJsonToObject(jsonElement, type);
                listToReturn.add(convertJsonToObject);
            }
            return listToReturn;
        }
        return null;
    }

    public static <T> T convertJsonToObject(JsonElement jsonElementToSerialize, Class<T> type) throws IOException {
        if (jsonElementToSerialize != null) {
            return gson.fromJson(jsonElementToSerialize, type);
        }
        return null;
    }

    public static Gson getGson() {
        return gson;
    }

    public static String convertObjectToJson(Object toConvert, Class<?> type) {
        if (toConvert != null) {
            return gson.toJson(toConvert, type);
        }
        return null;
    }

    public static JsonElement getJsonFromEntity(HttpEntity entity) throws IOException {
        if (entity != null) {
            InputStream content = entity.getContent();
            JsonElement parsedResponse = new JsonParser().parse(new InputStreamReader(content, "UTF-8"));
            return parsedResponse;
        }
        return null;
    }

    public static JsonElement createJsonObjectFromObject(Object toConvert, Class<?> type) {
        if (toConvert != null) {
            return gson.toJsonTree(toConvert, type);
        }
        return null;
    }

    public static BasicHttpEntity createJSONHttpEntity(String request) throws UnsupportedEncodingException {
        if (request == null) {
            throw new IllegalArgumentException("Cannot create entity, because parameter [request] is null.");
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(new ByteArrayInputStream(request.toString().getBytes("UTF-8")));
        entity.setContentType("application/json");
        return entity;
    }
}

