/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.utils;

import com.sap.cloud.account.ops.i18n.CommandMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResponseBuilderUtils {
    private static final String SPACE_DELIMITER = " ";
    private static final String TAB_DELIMETER = "\t";
    private static final String TWO_NEW_LINES = "\n\n";
    private static final String NEW_LINE = "\n";
    public static final String DELIMITER = "%delimeter%";
    public static final String TABLE_OUTPUT_FORMAT_TEMPLATE = "  %%-%ds\t: %%s";

    public static String buildTableTreeFromAccountsList(List<?> input, String initialLabel, CommandMessages messages, String ... columnNamesKeys) throws IOException {
        StringBuilder messageToBuild = new StringBuilder();
        ResponseBuilderUtils.buildTableHeader(initialLabel, messages, messageToBuild, columnNamesKeys);
        messageToBuild.append(TWO_NEW_LINES);
        ResponseBuilderUtils.buildTableContents(input, messageToBuild);
        return messageToBuild.toString();
    }

    private static void buildTableHeader(String initialLabelKey, CommandMessages messages, StringBuilder messageToBuild, String ... columnNamesKeys) {
        messageToBuild.append(messages.getMessage(initialLabelKey));
        messageToBuild.append(TWO_NEW_LINES);
        messageToBuild.append(SPACE_DELIMITER);
        for (String key : columnNamesKeys) {
            messageToBuild.append(messages.getMessage(key));
            messageToBuild.append(TAB_DELIMETER);
            messageToBuild.append(TAB_DELIMETER);
            messageToBuild.append(TAB_DELIMETER);
        }
    }

    private static void buildTableContents(List<?> input, StringBuilder messageToBuild) throws IOException {
        if (input != null) {
            for (Object object : input) {
                messageToBuild.append(object.toString());
            }
        }
    }

    public static String buildInitialMessage(String commandName, String accountName, String url, String userName, CommandMessages messages, Map<String, String> additionalParametersToDisplay) {
        return ResponseBuilderUtils.buildInitialMessage(commandName, accountName, url, userName, messages, additionalParametersToDisplay, null);
    }

    public static String buildInitialMessage(String commandName, String accountName, String url, String userName, CommandMessages messages, Map<String, String> additionalParametersToDisplay, String additionalDetails) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(messages.getGeneralMessage("accounts.account"));
        params.add(messages.getGeneralMessage("accounts.host"));
        params.add(messages.getGeneralMessage("accounts.user"));
        for (String parameterMessage : additionalParametersToDisplay.keySet()) {
            params.add(messages.getMessage(parameterMessage));
        }
        String tableFormat = String.format(TABLE_OUTPUT_FORMAT_TEMPLATE, ResponseBuilderUtils.getParameterMaxLength(params));
        StringBuilder initialMessage = new StringBuilder();
        initialMessage.append(messages.getGeneralMessage("accounts.request", commandName));
        initialMessage.append(NEW_LINE);
        initialMessage.append(String.format(tableFormat, messages.getGeneralMessage("accounts.account"), accountName));
        initialMessage.append(ResponseBuilderUtils.buildTableFormattedOutputStartingWithNewLine(additionalParametersToDisplay));
        initialMessage.append(String.format(tableFormat, messages.getGeneralMessage("accounts.host"), url));
        initialMessage.append(NEW_LINE);
        initialMessage.append(String.format(tableFormat, messages.getGeneralMessage("accounts.user"), userName));
        initialMessage.append(NEW_LINE);
        if (additionalDetails != null && !additionalDetails.isEmpty()) {
            initialMessage.append(additionalDetails);
            initialMessage.append(NEW_LINE);
        }
        return initialMessage.toString();
    }

    public static String buildBlockResponse(String initialLabelKey, List<?> input, CommandMessages messages, String ... labels) {
        StringBuilder messageToBuild = new StringBuilder();
        messageToBuild.append(messages.getMessage(initialLabelKey));
        messageToBuild.append(NEW_LINE);
        for (Object account : input) {
            String[] splittedAccountElements = account.toString().split(DELIMITER);
            for (int i = 0; i < labels.length; ++i) {
                messageToBuild.append(NEW_LINE);
                String toAppend = messages.getMessage(labels[i], splittedAccountElements[i]);
                messageToBuild.append(toAppend);
            }
            messageToBuild.append(NEW_LINE);
        }
        return messageToBuild.toString();
    }

    public static String buildTableFormattedOutputStartingWithNewLine(Map<String, String> keyValueMap) {
        String tableFormat = String.format(TABLE_OUTPUT_FORMAT_TEMPLATE, ResponseBuilderUtils.getParameterMaxLength(new ArrayList<String>(keyValueMap.keySet())));
        StringBuilder output = new StringBuilder();
        output.append(NEW_LINE);
        for (String key : keyValueMap.keySet()) {
            output.append(String.format(tableFormat, key, keyValueMap.get(key)));
            output.append(NEW_LINE);
        }
        return output.toString();
    }

    public static int getParameterMaxLength(List<String> params) {
        int maxLen = 0;
        for (String s : params) {
            int len;
            if (s == null || (len = s.length()) <= maxLen) continue;
            maxLen = len;
        }
        return maxLen;
    }
}

