/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.commercial.account.ops.utils.sibling;

import com.sap.cloud.account.ops.entites.ConfigurationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class CloneParameterParser {
    private static final String EMPTY = "";
    private static final String CSV_DELIMITER = ",";
    private static final String REGEX_TRIM_CHARS = "['\"\\s]+";
    private static final String REGEX_SPACES = "\\s*";
    private static final String REGEX_SPACES_AROUND_DELIMITER = "\\s*,\\s*";

    public static String getDelimiter() {
        return CSV_DELIMITER;
    }

    public static String parse(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Passed value is null!");
        }
        String extracted = CloneParameterParser.trimIgnoredEnclosingChars(value);
        extracted = CloneParameterParser.removeSpacesAroundDelimiter(extracted);
        return extracted.toLowerCase(Locale.ENGLISH);
    }

    public static Set<ConfigurationType> parseToOrderedSet(String value) {
        String[] parsed = CloneParameterParser.parseSplit(value);
        if (CloneParameterParser.isAllOptionSelected(parsed)) {
            return CloneParameterParser.getAllCloneableConfigurationTypes();
        }
        TreeSet<ConfigurationType> result = new TreeSet<ConfigurationType>();
        for (String typeString : parsed) {
            result.add(ConfigurationType.fromString(typeString));
        }
        return Collections.unmodifiableSet(result);
    }

    private static String[] parseSplit(String value) {
        return CloneParameterParser.parse(value).split(CSV_DELIMITER);
    }

    private static boolean isAllOptionSelected(String[] parsed) {
        return parsed.length == 1 && parsed[0].equalsIgnoreCase(ConfigurationType.ALL.toString());
    }

    private static String removeSpacesAroundDelimiter(String value) {
        if (value.contains(CSV_DELIMITER)) {
            return value.replaceAll(REGEX_SPACES_AROUND_DELIMITER, CSV_DELIMITER);
        }
        return value;
    }

    private static String trimIgnoredEnclosingChars(String value) {
        return value.replaceAll("^['\"\\s]+", EMPTY).replaceAll("['\"\\s]+$", EMPTY);
    }

    public static Set<ConfigurationType> getAllCloneableConfigurationTypes() {
        TreeSet<ConfigurationType> cloneable = new TreeSet<ConfigurationType>(Arrays.asList(ConfigurationType.values()));
        cloneable.remove((Object)ConfigurationType.ALL);
        return Collections.unmodifiableSet(cloneable);
    }
}

