/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.jco.session;

import com.sap.conn.jco.ext.JCoSessionReference;

public class NeoSessionReference
implements JCoSessionReference {
    private static final int ID_LENGHT = 28;
    private boolean alive;
    private String id;

    public NeoSessionReference(String sessionId, String scopeType) {
        this.id = sessionId + "[" + scopeType + "]";
    }

    public void contextFinished() {
        this.alive = false;
    }

    public void contextStarted() {
        this.alive = true;
    }

    public String getID() {
        return this.id;
    }

    boolean isAlive() {
        return this.alive;
    }

    static String createNewUniqueId() {
        return String.format("ID-%08x-%016x", 0xFFFFFFFFL & System.currentTimeMillis(), Thread.currentThread().getId());
    }

    static String extractUnitId(String sessionId) {
        if (sessionId.length() > 28) {
            return sessionId.substring(0, 28);
        }
        return sessionId;
    }
}

