/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.jco.session;

import com.sap.core.connectivity.jco.session.NeoSessionReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ProcessingUnitId {
    private static final String SESSION_SCOPE = "SESSION_SCOPE";
    private static final Collection<NeoSessionReference> EMPTY_ID_COLLECTION = new ArrayList<NeoSessionReference>(0);
    private String unitId;
    private String httpSessionId;
    private long httpSessionLastAccess;
    private HashMap<String, NeoSessionReference> scopes;
    private NeoSessionReference sessionScopeReference;

    public ProcessingUnitId(String id) {
        this.unitId = id;
    }

    boolean hasUnitId(String id) {
        return this.unitId.equals(id);
    }

    NeoSessionReference getSessionReference(String scopeType) {
        NeoSessionReference scopeReference;
        if (scopeType == null) {
            if (this.sessionScopeReference == null) {
                this.sessionScopeReference = new NeoSessionReference(this.unitId, SESSION_SCOPE);
            }
            return this.sessionScopeReference;
        }
        if (this.scopes == null) {
            this.scopes = new HashMap();
        }
        if ((scopeReference = this.scopes.get(scopeType)) == null) {
            scopeReference = new NeoSessionReference(this.unitId, scopeType);
            this.scopes.put(scopeType, scopeReference);
        }
        return scopeReference;
    }

    public void replace(String id) {
        this.unitId = id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("processing unit Id [").append(this.unitId).append("]");
        if (this.httpSessionId != null) {
            sb.append(" stateful in session ").append(this.httpSessionId).append(" last access ").append(this.httpSessionLastAccess);
        }
        return sb.toString();
    }

    public void setHttpSessionId(String id) {
        this.httpSessionId = id;
        this.httpSessionLastAccess = System.currentTimeMillis();
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    Collection<NeoSessionReference> getIds() {
        if (this.scopes == null) {
            return EMPTY_ID_COLLECTION;
        }
        return this.scopes.values();
    }

    NeoSessionReference getSessionScopeReference() {
        return this.sessionScopeReference;
    }
}

