/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.jco.session;

import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.core.connectivity.jco.session.NeoSessionReference;
import com.sap.core.connectivity.jco.session.ProcessingUnitId;
import com.sap.core.connectivity.jco.session.ProcessingUnitIdProviderBase;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessingUnitIdProviderImpl
extends ProcessingUnitIdProviderBase {
    private static final Logger log = Logger.getLogger((String)"com.sap.core.connectivity.jco");
    private ThreadLocalProcessingUnitId threadLocalUnitId = new ThreadLocalProcessingUnitId();
    private Hashtable<String, ProcessingUnitId> availableHttpSessions = new Hashtable();

    public void processingUnitStarted() {
        this.getProcessingUnitId();
    }

    public void useProcessingUnitId(String processingUnitId) {
        this.threadLocalUnitId.createAndSet(processingUnitId);
        log.trace((Object)("jco session id is  " + ((ProcessingUnitId)this.threadLocalUnitId.get()).getSessionScopeReference().getID()));
    }

    public ProcessingUnitId getProcessingUnitId() {
        ProcessingUnitId processingUnitId = (ProcessingUnitId)this.threadLocalUnitId.get();
        if (processingUnitId == null) {
            processingUnitId = this.threadLocalUnitId.createAndSet(NeoSessionReference.createNewUniqueId());
        }
        return processingUnitId;
    }

    public void sessionCreated(String httpSessionId) {
        ProcessingUnitId processingUnitId = (ProcessingUnitId)this.threadLocalUnitId.get();
        if (processingUnitId.getHttpSessionId() == null) {
            processingUnitId.setHttpSessionId(httpSessionId);
            this.availableHttpSessions.put(httpSessionId, processingUnitId);
        }
    }

    public void sessionActivated(String id) {
        ProcessingUnitId processingUnitId = this.availableHttpSessions.get(id);
        if (processingUnitId != null) {
            this.threadLocalUnitId.set(processingUnitId);
        } else {
            this.sessionCreated(id);
        }
    }

    public void sessionDestroyed(String id) {
        ProcessingUnitId removedUnitId = this.availableHttpSessions.remove(id);
        if (removedUnitId != null) {
            removedUnitId.setHttpSessionId(null);
        }
    }

    public void processingUnitFinished() {
        try {
            ProcessingUnitId processingUnitId = (ProcessingUnitId)this.threadLocalUnitId.get();
            if (processingUnitId.getHttpSessionId() == null) {
                for (NeoSessionReference ref : processingUnitId.getIds()) {
                    this.fireFinished(ref.getID());
                }
                this.fireFinished(processingUnitId.getSessionScopeReference().getID());
            }
            this.threadLocalUnitId.remove();
        }
        catch (NullPointerException e) {
            log.error((Object)"JCo runtime is not initialized", (Throwable)e);
        }
    }

    public List<String> getRunningHttpSessions() {
        ArrayList<String> runningHttpSessions = new ArrayList<String>();
        for (ProcessingUnitId pui : this.availableHttpSessions.values()) {
            runningHttpSessions.add(pui.getHttpSessionId());
        }
        return runningHttpSessions;
    }

    @Override
    public JCoSessionReference getCurrentSessionReference(String scopeType) {
        ProcessingUnitId processingUnitId = (ProcessingUnitId)this.threadLocalUnitId.get();
        if (processingUnitId == null) {
            if (!"THREAD".equalsIgnoreCase(scopeType)) {
                throw new IllegalStateException("Request outside of request scope detected. Current thread is " + Thread.currentThread().getName() + " with id " + Thread.currentThread().getId() + " scope type is " + scopeType);
            }
            processingUnitId = this.getProcessingUnitId();
        }
        return processingUnitId.getSessionReference(scopeType);
    }

    public boolean isSessionAlive(String sessionId) {
        String unitId = NeoSessionReference.extractUnitId(sessionId);
        for (ProcessingUnitId pui : this.availableHttpSessions.values()) {
            if (!pui.hasUnitId(unitId)) continue;
            return true;
        }
        return false;
    }

    static class ThreadLocalProcessingUnitId
    extends InheritableThreadLocal<ProcessingUnitId> {
        ThreadLocalProcessingUnitId() {
        }

        public ProcessingUnitId createAndSet(String id) {
            ProcessingUnitId processingUnitId = new ProcessingUnitId(id);
            this.set(processingUnitId);
            return processingUnitId;
        }
    }
}

