/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.tomcat.valve;

import com.sap.core.js.monitoring.request.MetricsHandler;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class RequestTracingValve
extends ValveBase {
    public RequestTracingValve() {
        super(true);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (MetricsHandler.isHandlerProvided()) {
            long startTime = request.getCoyoteRequest().getStartTime();
            if (!request.isAsyncStarted()) {
                MetricsHandler.requestFinished((long)(System.currentTimeMillis() - startTime), (response.getStatus() >= 500 ? 1 : 0) != 0);
            } else {
                AsyncContext ac = request.getAsyncContext();
                ac.addListener((AsyncListener)new RequestTracingAsyncListener(startTime));
            }
        }
    }

    private static class RequestTracingAsyncListener
    implements AsyncListener {
        private long startTime;

        RequestTracingAsyncListener(long startTime) {
            this.startTime = startTime;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            boolean isError500 = false;
            ServletResponse response = event.getAsyncContext().getResponse();
            if (response instanceof HttpServletResponse) {
                isError500 = ((HttpServletResponse)response).getStatus() >= 500;
            }
            MetricsHandler.requestFinished((long)(System.currentTimeMillis() - this.startTime), (boolean)isError500);
        }

        public void onError(AsyncEvent arg0) throws IOException {
        }

        public void onStartAsync(AsyncEvent arg0) throws IOException {
        }

        public void onTimeout(AsyncEvent arg0) throws IOException {
        }
    }
}

