/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.tc.logging.Location;
import java.nio.charset.Charset;

public class SAML2ArtifactImpl
implements SAML2Artifact {
    private static final Location LOCATION = Location.getLocation(SAML2ArtifactImpl.class);
    private static final byte ARTIFACT_TYPE_CODE_BYTE_1 = 0;
    private static final byte ARTIFACT_TYPE_CODE_BYTE_2 = 4;
    private byte[] type;
    private byte[] endpointIndex;
    private byte[] sourceId;
    private byte[] messageHandle;
    private String artifactValue;

    public SAML2ArtifactImpl(String base64EncodedArtifact) throws SAML2Exception {
        LOCATION.entering("SAML2ArtifactImpl(String)", new Object[]{base64EncodedArtifact});
        this.artifactValue = base64EncodedArtifact;
        byte[] bytes = SAML2Utils.decodeBase64(this.artifactValue);
        if (bytes == null || bytes.length != 44) {
            throw new SAML2Exception("Unsupported artifact. Should be Base64 encoded 44 byte sequence. Artifact: " + base64EncodedArtifact);
        }
        this.type = this.extractBytes(bytes, 0, 2);
        if (this.type[0] != 0 || this.type[1] != 4) {
            throw new SAML2Exception("Unsupported artifact type. Should be 0x0004. Artifact type: " + new String(this.type, Charset.forName("UTF-8")));
        }
        this.endpointIndex = this.extractBytes(bytes, 2, 2);
        this.sourceId = this.extractBytes(bytes, 4, 20);
        this.messageHandle = this.extractBytes(bytes, 24, 20);
        LOCATION.exiting("SAML2ArtifactImpl(String)");
    }

    public SAML2ArtifactImpl(int endpointIndex, String issuerName, byte[] messageHandle) throws SAML2Exception {
        if (LOCATION.bePath()) {
            LOCATION.entering("SAML2ArtifactImpl(int, String, byte[])", new Object[]{endpointIndex, issuerName, messageHandle});
        }
        if (endpointIndex < 0 || endpointIndex > 65535) {
            throw new SAML2Exception("Invalid Endpoint Index argument value range. Should be between 0 and 65535");
        }
        if (issuerName == null || issuerName.length() < 1) {
            throw new SAML2Exception("Invalide issuer name: \"" + issuerName + "\"");
        }
        if (messageHandle == null || messageHandle.length != 20) {
            throw new SAML2Exception("Invalid message handle. Should be array of 20 bytes.");
        }
        byte[] byArray = new byte[2];
        byArray[1] = 4;
        this.type = byArray;
        this.endpointIndex = this.convertIntToTwoBytes(endpointIndex);
        this.sourceId = SAML2Utils.calculateSha1Hash(issuerName);
        this.messageHandle = messageHandle;
        this.artifactValue = this.convertToEncodedArtifactValue(this.type, this.endpointIndex, this.sourceId, this.messageHandle);
        LOCATION.exiting("SAML2ArtifactImpl(int, String, byte[])");
    }

    @Override
    public int getEndpointIndex() {
        return this.convertTwoBytesToInt(this.endpointIndex);
    }

    @Override
    public byte[] getMessageHandle() {
        return this.messageHandle;
    }

    @Override
    public byte[] getSourceID() {
        return this.sourceId;
    }

    @Override
    public byte[] getTypeCode() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.artifactValue;
    }

    public String toString() {
        return this.artifactValue;
    }

    private int convertTwoBytesToInt(byte[] bytes) {
        int result = ((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF);
        return result;
    }

    private byte[] convertIntToTwoBytes(int value) throws SAML2Exception {
        byte[] result = new byte[]{(byte)(value >>> 8), (byte)value};
        return result;
    }

    private String convertToEncodedArtifactValue(byte[] type, byte[] endpointIndex, byte[] sourceId, byte[] messageHandle) throws SAML2Exception {
        byte[] artifactArray = new byte[44];
        System.arraycopy(type, 0, artifactArray, 0, 2);
        System.arraycopy(endpointIndex, 0, artifactArray, 2, 2);
        System.arraycopy(sourceId, 0, artifactArray, 4, 20);
        System.arraycopy(messageHandle, 0, artifactArray, 24, 20);
        String result = SAML2Utils.encodeBase64(artifactArray);
        return result;
    }

    private byte[] extractBytes(byte[] source, int beginIndex, int count) throws SAML2Exception {
        if (source == null || beginIndex + count > source.length) {
            throw new SAML2Exception("Invalid arguments");
        }
        byte[] result = new byte[count];
        int i = 0;
        while (i < result.length) {
            result[i] = source[beginIndex + i];
            ++i;
        }
        return result;
    }
}

