/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.AnyTypeImpl;
import com.sap.security.saml2.lib.assertions.SAML2AttributeStatementJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2AuthnStatementJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2EncryptedAssertionJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2EncryptedNameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2NonStandardDefinedConditionJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2ProxyRestrictionJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SignatureKeyInfoImpl;
import com.sap.security.saml2.lib.assertions.SAML2SubjectConfirmationJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AuthnStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NonStandardDefinedCondition;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2ProxyRestriction;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.jaxb.assertion.AssertionType;
import com.sap.security.saml2.lib.jaxb.assertion.AttributeStatementType;
import com.sap.security.saml2.lib.jaxb.assertion.AudienceRestrictionType;
import com.sap.security.saml2.lib.jaxb.assertion.AuthnStatementType;
import com.sap.security.saml2.lib.jaxb.assertion.ConditionAbstractType;
import com.sap.security.saml2.lib.jaxb.assertion.ConditionsType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.assertion.OneTimeUseType;
import com.sap.security.saml2.lib.jaxb.assertion.ProxyRestrictionType;
import com.sap.security.saml2.lib.jaxb.assertion.StatementAbstractType;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectConfirmationType;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectType;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.jaxb.xmlenc.EncryptedDataType;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureManager;
import com.sap.tc.logging.Location;
import java.io.StringWriter;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2AssertionJxbImpl
implements SAML2Assertion {
    private AssertionType signedAssertionJxb;
    private String id;
    private String version;
    private Date issueInstant;
    private SAML2NameID issuer;
    private List<String> conditionsAudienceRestriction;
    private Date conditionsNotBefore;
    private Date conditionsNotOnOrAfter;
    private boolean conditionsOneTimeUse;
    private SAML2ProxyRestriction conditionsProxyRestriction;
    private List<SAML2NonStandardDefinedCondition> conditionsNonStandardDefined;
    private List<SAML2AuthnStatement> authnStatements;
    private List<SAML2AttributeStatement> attributeStatements;
    private SAML2NameID subjectNameId;
    private SAML2EncryptedNameID encryptedSubjectNameId;
    private List<SAML2SubjectConfirmation> subjectConfirmations;
    private boolean isSigned;
    private SAML2SignatureKeyInfo signatureKeyInfo;
    private Element signedAssertionElement;
    private String signedAssertionXML;
    private String assertionXML;
    private String xmlRepresentationForTrace;
    private String xmlRepresentationForPrinciplePropagation;
    private String digestAlgorithm;
    private static final Location LOCATION = Location.getLocation(SAML2AssertionJxbImpl.class);

    public SAML2AssertionJxbImpl(String id, String version, Date issueInstant, SAML2NameID issuer, List<SAML2AuthnStatement> authnStatements) {
        this.id = id;
        this.version = version;
        this.issueInstant = issueInstant != null ? issueInstant : new Date();
        this.issuer = issuer;
        this.authnStatements = authnStatements;
    }

    public SAML2AssertionJxbImpl(String assertionXML) throws SAML2Exception {
        this.assertionXML = assertionXML;
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromText(assertionXML);
        Object object = jaxbElement.getValue();
        if (!(object instanceof AssertionType)) {
            throw new SAML2Exception("Invalid type. Must be \"Assertion\".");
        }
        AssertionType assertion = (AssertionType)object;
        this.parse(assertion);
    }

    public SAML2AssertionJxbImpl(Element element) throws SAML2Exception {
        this.signedAssertionElement = element;
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM(element);
        Object object = jaxbElement.getValue();
        if (!(object instanceof AssertionType)) {
            throw new SAML2Exception("Invalid type. Must be \"Assertion\".");
        }
        AssertionType assertion = (AssertionType)object;
        this.parse(assertion);
    }

    public SAML2AssertionJxbImpl(AssertionType assertion, Element signedAssertionElement) throws SAML2Exception {
        if (assertion == null) {
            throw new SAML2Exception("The assertion cannot be null.");
        }
        this.signedAssertionElement = signedAssertionElement;
        this.parse(assertion);
    }

    private void parse(AssertionType assertion) throws SAML2Exception {
        SignatureType signature;
        SubjectType subject;
        ConditionsType conditions;
        List<StatementAbstractType> statements;
        this.id = assertion.getID();
        this.version = assertion.getVersion();
        this.issueInstant = SAML2Utils.convertXMLGregorianCalendarToDate(assertion.getIssueInstant());
        NameIDType iss = assertion.getIssuer();
        if (iss != null) {
            this.issuer = new SAML2NameIDJxbImpl(iss);
        }
        if ((statements = assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement()) != null) {
            this.authnStatements = new ArrayList<SAML2AuthnStatement>();
            this.attributeStatements = new ArrayList<SAML2AttributeStatement>();
            for (StatementAbstractType statement : statements) {
                if (statement instanceof AuthnStatementType) {
                    SAML2AuthnStatementJxbImpl authn = new SAML2AuthnStatementJxbImpl((AuthnStatementType)statement);
                    this.authnStatements.add(authn);
                    continue;
                }
                if (!(statement instanceof AttributeStatementType)) continue;
                SAML2AttributeStatementJxbImpl attrStatement = new SAML2AttributeStatementJxbImpl((AttributeStatementType)statement);
                this.attributeStatements.add(attrStatement);
            }
        }
        if ((conditions = assertion.getConditions()) != null) {
            this.conditionsAudienceRestriction = new ArrayList<String>();
            this.conditionsNonStandardDefined = new ArrayList<SAML2NonStandardDefinedCondition>();
            List<ConditionAbstractType> abstractConditions = conditions.getConditionOrAudienceRestrictionOrOneTimeUse();
            for (ConditionAbstractType abstractCondition : abstractConditions) {
                if (abstractCondition instanceof AudienceRestrictionType) {
                    AudienceRestrictionType restriction = (AudienceRestrictionType)abstractCondition;
                    List<String> aududience = restriction.getAudience();
                    if (aududience == null) continue;
                    this.conditionsAudienceRestriction.addAll(aududience);
                    continue;
                }
                if (abstractCondition instanceof OneTimeUseType) {
                    this.conditionsOneTimeUse = true;
                    continue;
                }
                if (abstractCondition instanceof ProxyRestrictionType) {
                    this.conditionsProxyRestriction = new SAML2ProxyRestrictionJxbImpl((ProxyRestrictionType)abstractCondition);
                    continue;
                }
                this.conditionsNonStandardDefined.add(new SAML2NonStandardDefinedConditionJxbImpl(abstractCondition));
            }
            List<Object> unknownConditions = conditions.getUnknownCondition();
            for (Object e : unknownConditions) {
                if (e instanceof Element) {
                    this.conditionsNonStandardDefined.add(new SAML2NonStandardDefinedConditionJxbImpl(new AnyTypeImpl((Element)e)));
                    continue;
                }
                if (!(e instanceof JAXBElement)) continue;
                this.conditionsNonStandardDefined.add(new SAML2NonStandardDefinedConditionJxbImpl(new AnyTypeImpl((JAXBElement)e)));
            }
            this.conditionsNotBefore = SAML2Utils.convertXMLGregorianCalendarToDate(conditions.getNotBefore());
            this.conditionsNotOnOrAfter = SAML2Utils.convertXMLGregorianCalendarToDate(conditions.getNotOnOrAfter());
        }
        if ((subject = assertion.getSubject()) != null) {
            List<SubjectConfirmationType> confirmations;
            EncryptedElementType encryptedElementType;
            NameIDType nameId = subject.getNameID();
            if (nameId != null) {
                this.subjectNameId = new SAML2NameIDJxbImpl(nameId);
            }
            if ((encryptedElementType = subject.getEncryptedID()) != null) {
                this.encryptedSubjectNameId = new SAML2EncryptedNameIDJxbImpl(encryptedElementType);
            }
            if ((confirmations = subject.getSubjectConfirmation()) != null) {
                this.subjectConfirmations = new ArrayList<SAML2SubjectConfirmation>();
                for (SubjectConfirmationType confirmation : confirmations) {
                    if (confirmation == null) continue;
                    this.subjectConfirmations.add(new SAML2SubjectConfirmationJxbImpl(confirmation));
                }
            }
        }
        if ((signature = assertion.getSignature()) != null) {
            this.isSigned = true;
            KeyInfoType keyInfoType = signature.getKeyInfo();
            if (keyInfoType != null) {
                this.signatureKeyInfo = new SAML2SignatureKeyInfoImpl(keyInfoType);
            }
        }
    }

    @Override
    public AssertionType convertToSAMLGenerator() throws SAML2Exception {
        if (this.signedAssertionJxb != null) {
            return this.signedAssertionJxb;
        }
        com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory();
        AssertionType assertion = factory.createAssertionType();
        try {
            StatementAbstractType jaxbStatement;
            assertion.setID(this.id);
            assertion.setVersion(this.version);
            if (this.issueInstant != null) {
                assertion.setIssueInstant(SAML2Utils.convertDateToXMLGregorianCalendar(this.issueInstant));
            }
            if (this.issuer != null) {
                assertion.setIssuer(this.issuer.convertToSAMLGenerator());
            }
            if (this.authnStatements != null) {
                for (SAML2AuthnStatement sAML2AuthnStatement : this.authnStatements) {
                    jaxbStatement = ((SAML2AuthnStatementJxbImpl)sAML2AuthnStatement).convertToSAMLGenerator();
                    if (jaxbStatement == null) continue;
                    assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(jaxbStatement);
                }
            }
            if (this.attributeStatements != null) {
                for (SAML2AttributeStatement sAML2AttributeStatement : this.attributeStatements) {
                    jaxbStatement = ((SAML2AttributeStatementJxbImpl)sAML2AttributeStatement).convertToSAMLGenerator();
                    if (jaxbStatement == null) continue;
                    assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(jaxbStatement);
                }
            }
            if (this.conditionsAudienceRestriction != null || this.conditionsNotBefore != null || this.conditionsOneTimeUse || this.conditionsNotOnOrAfter != null || this.conditionsProxyRestriction != null) {
                ConditionsType conditionsType = factory.createConditionsType();
                if (this.conditionsNotBefore != null) {
                    conditionsType.setNotBefore(SAML2Utils.convertDateToXMLGregorianCalendar(this.conditionsNotBefore));
                }
                if (this.conditionsNotOnOrAfter != null) {
                    conditionsType.setNotOnOrAfter(SAML2Utils.convertDateToXMLGregorianCalendar(this.conditionsNotOnOrAfter));
                }
                if (this.conditionsOneTimeUse) {
                    OneTimeUseType oneTimeUse = factory.createOneTimeUseType();
                    conditionsType.getConditionOrAudienceRestrictionOrOneTimeUse().add(oneTimeUse);
                }
                if (this.conditionsAudienceRestriction != null && this.conditionsAudienceRestriction.size() > 0) {
                    AudienceRestrictionType audience = factory.createAudienceRestrictionType();
                    audience.getAudience().addAll(this.conditionsAudienceRestriction);
                    conditionsType.getConditionOrAudienceRestrictionOrOneTimeUse().add(audience);
                }
                if (this.conditionsProxyRestriction != null) {
                    ProxyRestrictionType proxyRestriction = (ProxyRestrictionType)this.conditionsProxyRestriction.convertToSAMLGenerator();
                    conditionsType.getConditionOrAudienceRestrictionOrOneTimeUse().add(proxyRestriction);
                }
                assertion.setConditions(conditionsType);
            }
            if (this.subjectNameId != null || this.encryptedSubjectNameId != null || this.subjectConfirmations != null) {
                SubjectType subjectType = factory.createSubjectType();
                if (this.subjectNameId != null) {
                    subjectType.setNameID(this.subjectNameId.convertToSAMLGenerator());
                }
                if (this.encryptedSubjectNameId != null) {
                    subjectType.setEncryptedID(((SAML2EncryptedNameIDJxbImpl)this.encryptedSubjectNameId).convertToSAMLGenerator());
                }
                if (this.subjectConfirmations != null) {
                    for (SAML2SubjectConfirmation confirmation : this.subjectConfirmations) {
                        SubjectConfirmationType jaxbConfirmation;
                        if (confirmation == null || (jaxbConfirmation = ((SAML2SubjectConfirmationJxbImpl)confirmation).convertToSAMLGenerator()) == null) continue;
                        subjectType.getSubjectConfirmation().add(jaxbConfirmation);
                    }
                }
                assertion.setSubject(subjectType);
            }
        }
        catch (Exception exception) {
            throw new SAML2Exception("Failed to convert to Assertion", exception);
        }
        return assertion;
    }

    @Override
    public String generate() throws SAML2Exception {
        if (this.signedAssertionXML != null) {
            return this.signedAssertionXML;
        }
        AssertionType jaxbAssertion = this.convertToSAMLGenerator();
        JAXBElement<AssertionType> assertion = new com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory().createAssertion(jaxbAssertion);
        String result = SAML2JAXBUtils.marshalAssertionTokenToText(assertion);
        return result;
    }

    @Override
    public SAML2SignatureKeyInfo getSignatureKeyInfo() {
        return this.signatureKeyInfo;
    }

    public Element getSignedAssertion() throws SAML2Exception {
        if (this.assertionXML != null && this.signedAssertionElement == null) {
            this.signedAssertionElement = SAML2Utils.transformXMLtoDOM(this.assertionXML).getDocumentElement();
        }
        return this.signedAssertionElement;
    }

    @Override
    public List<SAML2SubjectConfirmation> getSubjectConfirmations() {
        return this.subjectConfirmations;
    }

    @Override
    public SAML2NameID getSubjectNameID() {
        return this.subjectNameId;
    }

    @Override
    public SAML2EncryptedNameID getEncryptedSubjectNameID() {
        return this.encryptedSubjectNameId;
    }

    @Override
    public void setSubjectConfirmations(List<SAML2SubjectConfirmation> confirmations) {
        this.subjectConfirmations = confirmations;
    }

    @Override
    public void setSubjectNameID(SAML2NameID nameId) {
        if (nameId != null) {
            if (LOCATION.beDebug() && this.encryptedSubjectNameId != null) {
                LOCATION.debugT("The encrypted subject nameID: " + this.encryptedSubjectNameId + " will be replaced by the plain subject nameId: " + nameId);
            }
            this.encryptedSubjectNameId = null;
            this.subjectNameId = nameId;
        }
    }

    @Override
    public void setEncryptedSubjectNameID(SAML2EncryptedNameID encryptedNameId) {
        if (encryptedNameId != null) {
            if (LOCATION.beDebug() && this.subjectNameId != null) {
                LOCATION.debugT("The plain nameID: " + this.subjectNameId + " will be replaced by the encrypted nameId: " + encryptedNameId);
            }
            this.subjectNameId = null;
            this.encryptedSubjectNameId = encryptedNameId;
        }
    }

    @Override
    public List<SAML2AuthnStatement> getAuthnStatement() {
        return this.authnStatements;
    }

    @Override
    public List<SAML2AttributeStatement> getAttributeStatements() {
        return this.attributeStatements;
    }

    @Override
    public void setAttributeStatements(List<SAML2AttributeStatement> statements) {
        this.attributeStatements = statements;
    }

    @Override
    public List<String> getConditionsAudienceRestriction() {
        return this.conditionsAudienceRestriction;
    }

    @Override
    public Date getConditionsNotBefore() {
        return this.conditionsNotBefore;
    }

    @Override
    public Date getConditionsNotOnOrAfter() {
        return this.conditionsNotOnOrAfter;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Date getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public SAML2NameID getIssuer() {
        return this.issuer;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isConditionsOneTimeUse() {
        return this.conditionsOneTimeUse;
    }

    @Override
    public void setConditionsAudienceRestriction(List<String> audiences) {
        this.conditionsAudienceRestriction = audiences;
    }

    @Override
    public void setConditionsNotBefore(Date date) {
        this.conditionsNotBefore = date;
    }

    @Override
    public void setConditionsNotOnOrAfter(Date date) {
        this.conditionsNotOnOrAfter = date;
    }

    @Override
    public void setConditionsOneTimeUse(boolean oneTimeUse) {
        this.conditionsOneTimeUse = oneTimeUse;
    }

    @Override
    public SAML2EncryptedAssertion encrypt(Key recepientPublicKey, String algorithmURI) throws SAML2Exception {
        try {
            Element toEncrypt;
            com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory();
            if (this.isSigned) {
                toEncrypt = this.getSignedAssertion();
            } else {
                AssertionType assertionType = this.convertToSAMLGenerator();
                JAXBElement<AssertionType> assertionJaxbElement = factory.createAssertion(assertionType);
                Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(assertionJaxbElement);
                toEncrypt = doc.getDocumentElement();
            }
            Node encryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().encrypt(toEncrypt, recepientPublicKey, algorithmURI);
            JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM((Element)encryptedDOMNode);
            EncryptedElementType jaxbEncryptedElement = factory.createEncryptedElementType();
            jaxbEncryptedElement.setEncryptedData((EncryptedDataType)jaxbElement.getValue());
            return new SAML2EncryptedAssertionJxbImpl(jaxbEncryptedElement);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to encrypt the SAML2 assertion", e);
        }
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public void sign(PrivateKey key) throws SAML2Exception {
        this.sign(key, null);
    }

    @Override
    public void sign(PrivateKey key, Certificate cert) throws SAML2Exception {
        com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory();
        try {
            AssertionType signedAssertion;
            AssertionType assertion = this.convertToSAMLGenerator();
            SignatureType dummySignature = new ObjectFactory().createSignatureType();
            assertion.setSignature(dummySignature);
            JAXBElement<AssertionType> assertionJaxbElement = factory.createAssertion(assertion);
            Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(assertionJaxbElement);
            Element parent = doc.getDocumentElement();
            XMLSignature signer = XMLSignatureManager.getXMLSignatureInstance();
            StringWriter signedXML = new StringWriter(2000);
            signer.sign(parent, this.getID(), key, cert, signedXML, this.digestAlgorithm);
            this.signedAssertionXML = signedXML.toString();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Signed assertion: " + this.signedAssertionXML);
            }
            this.signedAssertionElement = parent;
            JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM(parent);
            this.signedAssertionJxb = signedAssertion = (AssertionType)jaxbElement.getValue();
            this.isSigned = true;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to sign the Assertion", e);
        }
    }

    @Override
    public void validateSignature(Certificate senderCert) throws SAML2Exception {
        if (!this.isSigned) {
            throw new SAML2Exception("The assertion is not signed.");
        }
        XMLSignature verifier = XMLSignatureManager.getXMLSignatureInstance();
        if (!verifier.verify(this.getSignedAssertion(), senderCert)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Signature verification for Assertion with id: " + this.id + " failed.");
            }
            throw new SAML2Exception("Signature not valid!");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Signature for Assertion with id: " + this.id + " verified successfuly.");
        }
    }

    @Override
    public SAML2ProxyRestriction getConditionsProxyRestriction() {
        return this.conditionsProxyRestriction;
    }

    @Override
    public void setConditionsProxyRestriction(SAML2ProxyRestriction conditionsProxyRestriction) {
        this.conditionsProxyRestriction = conditionsProxyRestriction;
    }

    @Override
    public List<SAML2NonStandardDefinedCondition> getConditionsNonStandardDefined() {
        return this.conditionsNonStandardDefined;
    }

    @Override
    public void setConditionsNonStandardDefined(List<SAML2NonStandardDefinedCondition> conditionsNonStandardDefined) {
        this.conditionsNonStandardDefined = conditionsNonStandardDefined;
    }

    @Override
    public String getXMLRepresentation() {
        if (this.xmlRepresentationForTrace == null) {
            this.obtainXMLRepresenationForTrace();
        }
        return this.xmlRepresentationForTrace;
    }

    private void obtainXMLRepresenationForTrace() {
        if (this.assertionXML != null) {
            this.xmlRepresentationForTrace = this.assertionXML.replaceAll("\\>\\<", ">\n<");
        } else if (this.signedAssertionXML != null) {
            this.xmlRepresentationForTrace = this.signedAssertionXML.replaceAll("\\>\\<", ">\n<");
        } else if (this.signedAssertionElement != null) {
            this.xmlRepresentationForTrace = SAML2Utils.transformDOMForTrace(this.signedAssertionElement);
        }
    }

    @Override
    public String getXMLRepresentationForPrinciplePropagation() {
        if (this.xmlRepresentationForPrinciplePropagation == null) {
            if (this.assertionXML != null) {
                this.xmlRepresentationForPrinciplePropagation = this.assertionXML.replaceAll("\\>\\<", "><");
            } else if (this.signedAssertionXML != null) {
                this.xmlRepresentationForPrinciplePropagation = this.signedAssertionXML.replaceAll("\\>\\<", "><");
            } else if (this.signedAssertionElement != null) {
                try {
                    this.xmlRepresentationForPrinciplePropagation = SAML2Utils.transformDOMtoXML(this.signedAssertionElement);
                }
                catch (SAML2Exception tr) {
                    LOCATION.errorT("Cannot transform SAML2 assertion for principle propagation. The error is: " + tr.toString());
                }
            }
        }
        return this.xmlRepresentationForPrinciplePropagation;
    }

    @Override
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

