/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedAttributeJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAttribute;
import com.sap.security.saml2.lib.jaxb.assertion.AttributeType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmlenc.EncryptedDataType;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import com.sap.tc.logging.Location;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2AttributeJxbImpl
implements SAML2Attribute {
    private static final String X509_LDAP_PROFILE_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500";
    private static final String X509_LDAP_PROFILE_ENCODING_ATTRIBUTE = "Encoding";
    private static final Location LOCATION = Location.getLocation(SAML2AttributeJxbImpl.class);
    private String name;
    private String nameFormat;
    private String friendlyName;
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    List<Object> attributeValues = new ArrayList<Object>();

    public SAML2AttributeJxbImpl(String name) throws SAML2Exception {
        if (name == null || name.length() < 1) {
            throw new SAML2Exception("Invalid name: " + name);
        }
        this.name = name;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2 attribute with name: {0} is created", new Object[]{name});
        }
    }

    public SAML2AttributeJxbImpl(AttributeType attribute) throws SAML2Exception {
        if (attribute == null) {
            throw new SAML2Exception("The attribute cannot be null.");
        }
        this.name = attribute.getName();
        this.nameFormat = attribute.getNameFormat();
        this.friendlyName = attribute.getFriendlyName();
        this.otherAttributes = attribute.getOtherAttributes();
        this.attributeValues.addAll(attribute.getAttributeValue());
    }

    @Override
    public AttributeType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        AttributeType attribute = factory.createAttributeType();
        attribute.setName(this.name);
        attribute.setNameFormat(this.nameFormat);
        attribute.setFriendlyName(this.friendlyName);
        if (this.otherAttributes != null && this.otherAttributes.size() > 0) {
            attribute.getOtherAttributes().putAll(this.otherAttributes);
        }
        if (this.attributeValues != null && this.attributeValues.size() > 0) {
            attribute.getAttributeValue().addAll(this.attributeValues);
        }
        return attribute;
    }

    @Override
    public void addOtherXMLAttribute(QName name, String value) {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Added other XML attribute with name: {0} and value: {1} ", new Object[]{name, value});
        }
        this.otherAttributes.put(name, value);
    }

    @Override
    public SAML2EncryptedAttribute encrypt(Key recepientPublicKey, String algorithmURI) throws SAML2Exception {
        try {
            ObjectFactory factory = new ObjectFactory();
            AttributeType attributeType = this.convertToSAMLGenerator();
            JAXBElement<AttributeType> attributeJaxbElement = factory.createAttribute(attributeType);
            Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(attributeJaxbElement);
            Element toEncrypt = doc.getDocumentElement();
            Node encryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().encrypt(toEncrypt, recepientPublicKey, algorithmURI);
            JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM((Element)encryptedDOMNode);
            EncryptedElementType jaxbEncryptedElement = factory.createEncryptedElementType();
            jaxbEncryptedElement.setEncryptedData((EncryptedDataType)jaxbElement.getValue());
            return new SAML2EncryptedAttributeJxbImpl(jaxbEncryptedElement);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to encrypt the SAML2 assertion", e);
        }
    }

    @Override
    public List<Object> getAttributeValues() {
        return this.attributeValues;
    }

    @Override
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameFormat() {
        return this.nameFormat;
    }

    @Override
    public Map<QName, String> getOtherXMLAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setAttributeValues(List<Object> values) {
        if (values != null && values.size() > 0) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Added attribute values: " + values);
            }
            this.attributeValues.addAll(values);
        }
    }

    @Override
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Friendly name is set to: " + friendlyName);
        }
    }

    @Override
    public void setNameFormat(String uri) {
        this.nameFormat = uri;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Name format is set to: " + uri);
        }
    }

    @Override
    public String getX509Encoding() {
        Set<QName> names = this.otherAttributes.keySet();
        for (QName name : names) {
            if (!X509_LDAP_PROFILE_NAMESPACE.equals(name.getNamespaceURI()) || !X509_LDAP_PROFILE_ENCODING_ATTRIBUTE.equals(name.getLocalPart())) continue;
            return this.otherAttributes.get(name);
        }
        return null;
    }

    @Override
    public void setX509Encoding(String encoding) {
        if (encoding != null) {
            QName key = new QName(X509_LDAP_PROFILE_NAMESPACE, X509_LDAP_PROFILE_ENCODING_ATTRIBUTE);
            this.otherAttributes.put(key, encoding);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("X509 Encoding attribute is set to: " + encoding);
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("X509 Encoding attribute is not set because the specified encoding is null");
        }
    }
}

