/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2AttributeJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2EncryptedAttributeJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAttribute;
import com.sap.security.saml2.lib.jaxb.assertion.AttributeStatementType;
import com.sap.security.saml2.lib.jaxb.assertion.AttributeType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import java.util.ArrayList;
import java.util.List;

public class SAML2AttributeStatementJxbImpl
implements SAML2AttributeStatement {
    private List<SAML2Attribute> attributes = new ArrayList<SAML2Attribute>();
    private List<SAML2EncryptedAttribute> encryptedAttributes = new ArrayList<SAML2EncryptedAttribute>();

    @Override
    public AttributeStatementType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        AttributeStatementType statement = factory.createAttributeStatementType();
        for (SAML2Attribute attribute : this.attributes) {
            statement.getAttributeOrEncryptedAttribute().add(attribute.convertToSAMLGenerator());
        }
        for (SAML2EncryptedAttribute encAttribute : this.encryptedAttributes) {
            statement.getAttributeOrEncryptedAttribute().add(encAttribute.convertToSAMLGenerator());
        }
        return statement;
    }

    public SAML2AttributeStatementJxbImpl(AttributeStatementType attributeStatement) throws SAML2Exception {
        if (attributeStatement == null) {
            throw new SAML2Exception("The attribute statement cannot be null.");
        }
        List<Object> jaxbAttributes = attributeStatement.getAttributeOrEncryptedAttribute();
        if (jaxbAttributes != null) {
            for (Object jaxbAttribute : jaxbAttributes) {
                if (jaxbAttribute instanceof AttributeType) {
                    this.attributes.add(new SAML2AttributeJxbImpl((AttributeType)jaxbAttribute));
                    continue;
                }
                if (!(jaxbAttribute instanceof EncryptedElementType)) continue;
                this.encryptedAttributes.add(new SAML2EncryptedAttributeJxbImpl((EncryptedElementType)jaxbAttribute));
            }
        }
    }

    public SAML2AttributeStatementJxbImpl(List attributesOrEncryptedAttributes) throws SAML2Exception {
        if (attributesOrEncryptedAttributes == null || attributesOrEncryptedAttributes.size() < 1) {
            throw new SAML2Exception("At least one attribute (plain or encrypted) must be specified in the attribute statement.");
        }
        for (Object att : attributesOrEncryptedAttributes) {
            if (att instanceof SAML2Attribute) {
                this.attributes.add((SAML2Attribute)att);
                continue;
            }
            if (att instanceof SAML2EncryptedAttribute) {
                this.encryptedAttributes.add((SAML2EncryptedAttribute)att);
                continue;
            }
            throw new SAML2Exception("Invalid attribute found: " + att + ". Must be instance either of SAML2Attribute or SAML2EncryptedAttribute");
        }
    }

    @Override
    public List<SAML2Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<SAML2EncryptedAttribute> getEncryptedAttributes() {
        return this.encryptedAttributes;
    }
}

