/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AuthnStatement;
import com.sap.security.saml2.lib.jaxb.assertion.AuthnContextType;
import com.sap.security.saml2.lib.jaxb.assertion.AuthnStatementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectLocalityType;
import java.util.Date;
import java.util.List;

public class SAML2AuthnStatementJxbImpl
implements SAML2AuthnStatement {
    private Date authnInstant;
    private String sessionIndex;
    private Date sessionNotOnOrAfter;
    private String subjectLocalityAddress;
    private String subjectLocalityDNSName;
    private String authnContextClassRef;
    private List<String> authenticatingAuthorities;
    private String authnContextDecl;
    private String authnContextDeclRef;

    public SAML2AuthnStatementJxbImpl(Date authnInstant) {
        this.authnInstant = authnInstant != null ? authnInstant : new Date();
    }

    public SAML2AuthnStatementJxbImpl(AuthnStatementType authnStatement) throws SAML2Exception {
        AuthnContextType context;
        if (authnStatement == null) {
            throw new SAML2Exception("The authnStatement cannot be null.");
        }
        this.authnInstant = SAML2Utils.convertXMLGregorianCalendarToDate(authnStatement.getAuthnInstant());
        this.sessionIndex = authnStatement.getSessionIndex();
        this.sessionNotOnOrAfter = SAML2Utils.convertXMLGregorianCalendarToDate(authnStatement.getSessionNotOnOrAfter());
        SubjectLocalityType subject = authnStatement.getSubjectLocality();
        if (subject != null) {
            this.subjectLocalityAddress = subject.getAddress();
            this.subjectLocalityDNSName = subject.getDNSName();
        }
        if ((context = authnStatement.getAuthnContext()) != null) {
            Object anyType;
            this.authnContextClassRef = context.getAuthnContextClassRef();
            List<String> jaxbAuthenticatingAuthorities = context.getAuthenticatingAuthority();
            if (jaxbAuthenticatingAuthorities != null && jaxbAuthenticatingAuthorities.size() > 0) {
                this.authenticatingAuthorities = jaxbAuthenticatingAuthorities;
            }
            if ((anyType = context.getAuthnContextDecl()) != null) {
                this.authnContextDecl = anyType.toString();
            }
            this.authnContextDeclRef = context.getAuthnContextDeclRef();
        }
    }

    @Override
    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    @Override
    public String getAuthnContextDecl() {
        return this.authnContextDecl;
    }

    @Override
    public String getAuthnContextDeclRef() {
        return this.authnContextDeclRef;
    }

    @Override
    public Date getAuthnInstant() {
        return this.authnInstant;
    }

    @Override
    public String getSessionIndex() {
        return this.sessionIndex;
    }

    @Override
    public Date getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    @Override
    public String getSubjectLocalityAddress() {
        return this.subjectLocalityAddress;
    }

    @Override
    public String getSubjectLocalityDNSName() {
        return this.subjectLocalityDNSName;
    }

    @Override
    public void setAuthnContextClassRef(String uri) {
        this.authnContextClassRef = uri;
    }

    @Override
    public List<String> getAuthenticatingAuthorities() {
        return this.authenticatingAuthorities;
    }

    @Override
    public void setAuthenticatingAuthorities(List<String> authenticatingAuthorities) {
        this.authenticatingAuthorities = authenticatingAuthorities;
    }

    @Override
    public void setAuthnContextDecl(String anyType) {
        this.authnContextDecl = anyType;
    }

    @Override
    public void setAuthnContextDeclRef(String uri) {
        this.authnContextDeclRef = uri;
    }

    @Override
    public void setSessionIndex(String index) {
        this.sessionIndex = index;
    }

    @Override
    public void setSessionNotOnOrAfter(Date date) {
        this.sessionNotOnOrAfter = date;
    }

    @Override
    public void setSubjectLocalityAddress(String address) {
        this.subjectLocalityAddress = address;
    }

    @Override
    public void setSubjectLocalityDNSName(String dnsName) {
        this.subjectLocalityDNSName = dnsName;
    }

    @Override
    public AuthnStatementType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        AuthnStatementType statement = factory.createAuthnStatementType();
        try {
            statement.setAuthnInstant(SAML2Utils.convertDateToXMLGregorianCalendar(this.authnInstant));
            statement.setSessionIndex(this.sessionIndex);
            if (this.sessionNotOnOrAfter != null) {
                statement.setSessionNotOnOrAfter(SAML2Utils.convertDateToXMLGregorianCalendar(this.sessionNotOnOrAfter));
            }
            if (this.subjectLocalityAddress != null || this.subjectLocalityDNSName != null) {
                SubjectLocalityType subject = factory.createSubjectLocalityType();
                subject.setAddress(this.subjectLocalityAddress);
                subject.setDNSName(this.subjectLocalityDNSName);
                statement.setSubjectLocality(subject);
            }
            if (this.authnContextClassRef != null || this.authnContextDecl != null || this.authnContextDeclRef != null || this.authenticatingAuthorities != null) {
                AuthnContextType context = factory.createAuthnContextType();
                context.setAuthnContextClassRef(this.authnContextClassRef);
                context.setAuthnContextDecl(this.authnContextDecl);
                context.setAuthnContextDeclRef(this.authnContextDeclRef);
                if (this.authenticatingAuthorities != null) {
                    context.getAuthenticatingAuthority().addAll(this.authenticatingAuthorities);
                }
                statement.setAuthnContext(context);
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to convert to AuthnStatement", e);
        }
        return statement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("Authentication Statement \n");
        builder.append("  Authentication Instant: ").append(this.authnInstant != null ? this.authnInstant : "").append("\n");
        builder.append("  Context: ").append(this.authnContextClassRef != null ? this.authnContextClassRef : "").append("\n");
        builder.append("  Authenticating Authorities: ").append(this.authenticatingAuthorities != null ? this.authenticatingAuthorities : "").append("\n");
        builder.append("  Session Index: ").append(this.sessionIndex != null ? this.sessionIndex : "").append("\n");
        builder.append("  Session NotOnOrAfter: ").append(this.sessionNotOnOrAfter != null ? this.sessionNotOnOrAfter : "").append("\n");
        return builder.toString();
    }
}

