/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2AssertionJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.jaxb.assertion.AssertionType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2EncryptedAssertionJxbImpl
implements SAML2EncryptedAssertion {
    EncryptedElementType encryptedElement;

    public SAML2EncryptedAssertionJxbImpl(EncryptedElementType encryptedAssertion) {
        this.encryptedElement = encryptedAssertion;
    }

    @Override
    public EncryptedElementType convertToSAMLGenerator() throws SAML2Exception {
        return this.encryptedElement;
    }

    @Override
    public SAML2Assertion decrypt(Key recipientPrivateKey) throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        JAXBElement<EncryptedElementType> encryptedAssertion = factory.createEncryptedAssertion(this.encryptedElement);
        Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(encryptedAssertion);
        Element encryptedDOM = doc.getDocumentElement();
        Node decryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().decrypt(encryptedDOM, recipientPrivateKey);
        Element decryptedDOMElement = (Element)decryptedDOMNode;
        JAXBElement decryptedAssertion = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM(decryptedDOMElement);
        return new SAML2AssertionJxbImpl((AssertionType)decryptedAssertion.getValue(), decryptedDOMElement);
    }
}

