/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2AttributeJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAttribute;
import com.sap.security.saml2.lib.jaxb.assertion.AttributeType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2EncryptedAttributeJxbImpl
implements SAML2EncryptedAttribute {
    EncryptedElementType encryptedElement;

    public SAML2EncryptedAttributeJxbImpl(EncryptedElementType encryptedAttribute) {
        this.encryptedElement = encryptedAttribute;
    }

    @Override
    public EncryptedElementType convertToSAMLGenerator() throws SAML2Exception {
        return this.encryptedElement;
    }

    @Override
    public SAML2Attribute decrypt(Key recipientPrivateKey) throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        JAXBElement<EncryptedElementType> encryptedAttribute = factory.createEncryptedAssertion(this.encryptedElement);
        Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(encryptedAttribute);
        Element encryptedDOM = doc.getDocumentElement();
        Node decryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().decrypt(encryptedDOM, recipientPrivateKey);
        Element decryptedDOMElement = (Element)decryptedDOMNode;
        JAXBElement decryptedAttribute = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM(decryptedDOMElement);
        return new SAML2AttributeJxbImpl((AttributeType)decryptedAttribute.getValue());
    }
}

