/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2EncryptedNameIDJxbImpl
implements SAML2EncryptedNameID {
    EncryptedElementType encryptedElement;

    public SAML2EncryptedNameIDJxbImpl(EncryptedElementType encryptedNameID) {
        this.encryptedElement = encryptedNameID;
    }

    @Override
    public EncryptedElementType convertToSAMLGenerator() throws SAML2Exception {
        return this.encryptedElement;
    }

    @Override
    public SAML2NameID decrypt(Key recipientPrivateKey) throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        JAXBElement<EncryptedElementType> encryptedNameID = factory.createEncryptedID(this.encryptedElement);
        Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(encryptedNameID);
        Element encryptedDOM = doc.getDocumentElement();
        Node decryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().decrypt(encryptedDOM, recipientPrivateKey);
        Element decryptedDOMElement = (Element)decryptedDOMNode;
        JAXBElement decryptedNameID = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM(decryptedDOMElement);
        return new SAML2NameIDJxbImpl((NameIDType)decryptedNameID.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("SAML2EncryptedNameID: encryptedElement=").append(this.encryptedElement).append(";");
        return builder.toString();
    }
}

