/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2NewIDJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNewID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NewID;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2EncryptedNewIDJxbImpl
implements SAML2EncryptedNewID {
    EncryptedElementType encryptedElement;

    public SAML2EncryptedNewIDJxbImpl(EncryptedElementType encryptedNewID) {
        this.encryptedElement = encryptedNewID;
    }

    @Override
    public EncryptedElementType convertToSAMLGenerator() {
        return this.encryptedElement;
    }

    @Override
    public SAML2NewID decrypt(Key recipientPrivateKey) throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        JAXBElement<EncryptedElementType> encryptedNewID = factory.createEncryptedID(this.encryptedElement);
        Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(encryptedNewID);
        Element encryptedDOM = doc.getDocumentElement();
        Node decryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().decrypt(encryptedDOM, recipientPrivateKey);
        Element decryptedDOMElement = (Element)decryptedDOMNode;
        JAXBElement decryptedNewID = SAML2JAXBUtils.unmarshalProtocolTokenFromDOM(decryptedDOMElement);
        return new SAML2NewIDJxbImpl((String)decryptedNewID.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("SAML2EncryptedNewID: encryptedElement=").append(this.encryptedElement).append(";");
        return builder.toString();
    }
}

