/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPEntry;
import com.sap.security.saml2.lib.jaxb.protocol.IDPEntryType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;

public class SAML2IDPEntryJxbImpl
implements SAML2IDPEntry {
    private String providerID;
    private String name;
    private String location;

    public SAML2IDPEntryJxbImpl(String providerID) throws SAML2Exception {
        if (providerID == null) {
            throw new SAML2Exception("Provider id cannot be null");
        }
        this.providerID = providerID;
    }

    public SAML2IDPEntryJxbImpl(IDPEntryType idpEntry) {
        this.providerID = idpEntry.getProviderID();
        this.name = idpEntry.getName();
        this.location = idpEntry.getLoc();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IDPEntryType convertToSAMLGenerator() {
        ObjectFactory factory = new ObjectFactory();
        IDPEntryType idpEntry = factory.createIDPEntryType();
        idpEntry.setProviderID(this.providerID);
        idpEntry.setName(this.name);
        idpEntry.setLoc(this.location);
        return idpEntry;
    }
}

