/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2KeyInfoJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SubjectConfirmationDataJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2KeyInfo;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2KeyInfoConfirmationData;
import com.sap.security.saml2.lib.jaxb.assertion.KeyInfoConfirmationDataType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.List;

public class SAML2KeyInfoConfirmationDataJxbImpl
extends SAML2SubjectConfirmationDataJxbImpl
implements SAML2KeyInfoConfirmationData {
    private static final Location LOCATION = Location.getLocation(SAML2KeyInfoConfirmationDataJxbImpl.class);
    private List<SAML2KeyInfo> keyInfos = new ArrayList<SAML2KeyInfo>();

    public SAML2KeyInfoConfirmationDataJxbImpl(List<SAML2KeyInfo> keyInfos) throws SAML2Exception {
        if (keyInfos == null || keyInfos.size() < 1) {
            throw new SAML2Exception("KeyInfo list could not be empty");
        }
        this.keyInfos = keyInfos;
    }

    public SAML2KeyInfoConfirmationDataJxbImpl(KeyInfoConfirmationDataType keyInfoConfirmationData) throws SAML2Exception {
        super(keyInfoConfirmationData);
        if (keyInfoConfirmationData == null) {
            throw new SAML2Exception("The KeyInfoConfirmationData cannot be null.");
        }
        List<KeyInfoType> jaxbKeyInfos = keyInfoConfirmationData.getKeyInfo();
        for (KeyInfoType keyInfoType : jaxbKeyInfos) {
            this.keyInfos.add(new SAML2KeyInfoJxbImpl(keyInfoType));
        }
    }

    @Override
    public KeyInfoConfirmationDataType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        KeyInfoConfirmationDataType keyConfData = factory.createKeyInfoConfirmationDataType();
        this.fillSubjectConfirmationData(keyConfData);
        if (this.keyInfos != null) {
            for (SAML2KeyInfo keyInfo : this.keyInfos) {
                KeyInfoType jaxbKeyInfo = ((SAML2KeyInfoJxbImpl)keyInfo).convertToSAMLGenerator();
                keyConfData.getKeyInfo().add(jaxbKeyInfo);
            }
        }
        return keyConfData;
    }

    @Override
    public List<SAML2KeyInfo> getKeyInfos() {
        return this.keyInfos;
    }
}

