/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2KeyInfo;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmldsig.X509DataType;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class SAML2KeyInfoJxbImpl
implements SAML2KeyInfo {
    private static final Location LOCATION = Location.getLocation(SAML2SignatureKeyInfo.class);
    private boolean isInitialized;
    private KeyInfoType jaxbKeyInfo;
    private List<String> keyNames = new ArrayList<String>();
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private List<String> certificatesBase64 = new ArrayList<String>();

    public SAML2KeyInfoJxbImpl() {
    }

    public SAML2KeyInfoJxbImpl(KeyInfoType jaxbKeyInfo) {
        this.jaxbKeyInfo = jaxbKeyInfo;
    }

    @Override
    public String getKeyName() {
        this.init();
        if (this.keyNames.size() > 0) {
            return this.keyNames.get(0);
        }
        return null;
    }

    @Override
    public X509Certificate getX509Certificate() {
        this.init();
        if (this.certificates.size() > 0) {
            return this.certificates.get(0);
        }
        return null;
    }

    @Override
    public String getX509CertificateBase64() {
        this.init();
        if (this.certificatesBase64.size() > 0) {
            return this.certificatesBase64.get(0);
        }
        return null;
    }

    @Override
    public void setKeyName(String name) {
        this.keyNames.clear();
        this.keyNames.add(name);
    }

    @Override
    public void setX509Certificate(X509Certificate cert) {
        this.certificates.clear();
        this.certificates.add(cert);
    }

    @Override
    public KeyInfoType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        this.jaxbKeyInfo = factory.createKeyInfoType();
        if (this.keyNames != null) {
            for (String keyName : this.keyNames) {
                JAXBElement<String> jaxbElement = factory.createKeyName(keyName);
                this.jaxbKeyInfo.getContent().add(jaxbElement);
            }
        }
        if (this.certificates != null) {
            X509DataType x509Data = factory.createX509DataType();
            for (X509Certificate certificate : this.certificates) {
                try {
                    JAXBElement<byte[]> x509CertElement = factory.createX509DataTypeX509Certificate(certificate.getEncoded());
                    x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(x509CertElement);
                }
                catch (CertificateEncodingException e) {
                    throw new SAML2Exception("Could not encode the certificate for KeyInfo element", e);
                }
            }
            JAXBElement<X509DataType> jaxbElement = factory.createX509Data(x509Data);
            this.jaxbKeyInfo.getContent().add(jaxbElement);
        }
        return this.jaxbKeyInfo;
    }

    private final synchronized void init() {
        if (!this.isInitialized) {
            if (this.jaxbKeyInfo != null) {
                this.parse(this.jaxbKeyInfo);
            }
            this.isInitialized = true;
        }
    }

    private void parse(KeyInfoType jaxbKeyInfo) {
        List<Object> content = jaxbKeyInfo.getContent();
        for (Object obj : content) {
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement jaxbElement = (JAXBElement)obj;
            if ("KeyName".equals(jaxbElement.getName().getLocalPart())) {
                String keyName = jaxbElement.getValue().toString();
                this.keyNames.add(keyName);
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Found Key Name in the KeyInfo: {0}", new Object[]{keyName});
                continue;
            }
            if (!"X509Data".equals(jaxbElement.getName().getLocalPart())) continue;
            try {
                String certBase64 = this.extractX509CertificateBase64(jaxbElement);
                if (certBase64 == null) continue;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Found X509 certificate in the KeyInfo: {0}", new Object[]{certBase64});
                }
                this.certificatesBase64.add(certBase64);
                try {
                    this.certificates.add(this.decodeX509Certificate(certBase64));
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(400, "Could not decode the certificate", (Throwable)e);
                }
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(400, "Could not Base64 encode the certificate", (Throwable)e);
            }
        }
    }

    private String extractX509CertificateBase64(JAXBElement jaxbElement) throws SAML2Exception {
        String certificateBase64 = null;
        byte[] bytes = null;
        List<Object> x509Data = ((X509DataType)jaxbElement.getValue()).getX509IssuerSerialOrX509SKIOrX509SubjectName();
        for (Object o : x509Data) {
            String elementName;
            if (!(o instanceof JAXBElement) || !"X509Certificate".equals(elementName = ((JAXBElement)o).getName().getLocalPart())) continue;
            bytes = (byte[])((JAXBElement)o).getValue();
        }
        if (bytes != null) {
            certificateBase64 = SAML2Utils.encodeBase64(bytes);
        }
        return certificateBase64;
    }

    private X509Certificate decodeX509Certificate(String certificateBase64) throws CertificateException, UnsupportedEncodingException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        String preparedCertificateBase64 = this.prepareCertificateBase64(certificateBase64);
        ByteArrayInputStream in1 = new ByteArrayInputStream(preparedCertificateBase64.getBytes("UTF-8"));
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(in1);
        return certificate;
    }

    private String prepareCertificateBase64(String certificateBase64) {
        String result = "-----BEGIN CERTIFICATE-----\n" + certificateBase64 + "\n-----END CERTIFICATE-----";
        return result;
    }
}

