/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedNameIDJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmlenc.EncryptedDataType;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2NameIDJxbImpl
implements SAML2NameID {
    private String name;
    private String format;
    private String nameQualifier;
    private String spNameQualifier;
    private String spProvidedID;

    public SAML2NameIDJxbImpl(String name) {
        this.name = name;
    }

    public SAML2NameIDJxbImpl(NameIDType nameId) {
        this.name = nameId.getValue();
        this.format = nameId.getFormat();
        this.nameQualifier = nameId.getNameQualifier();
        this.spNameQualifier = nameId.getSPNameQualifier();
        this.spProvidedID = nameId.getSPProvidedID();
    }

    @Override
    public NameIDType convertToSAMLGenerator() {
        ObjectFactory factory = new ObjectFactory();
        NameIDType nameId = factory.createNameIDType();
        nameId.setValue(this.name);
        nameId.setFormat(this.format);
        nameId.setNameQualifier(this.nameQualifier);
        nameId.setSPNameQualifier(this.spNameQualifier);
        nameId.setSPProvidedID(this.spProvidedID);
        return nameId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getNameQualifier() {
        return this.nameQualifier;
    }

    @Override
    public String getSPNameQualifier() {
        return this.spNameQualifier;
    }

    @Override
    public String getSPProvidedID() {
        return this.spProvidedID;
    }

    @Override
    public void setFormat(String uri) {
        this.format = uri;
    }

    @Override
    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = nameQualifier;
    }

    @Override
    public void setSPNameQualifier(String spNameQualifier) {
        this.spNameQualifier = spNameQualifier;
    }

    @Override
    public void setSPProvidedID(String spProvidedID) {
        this.spProvidedID = spProvidedID;
    }

    @Override
    public SAML2EncryptedNameID encrypt(Key recepientPublicKey, String algorithmURI) throws SAML2Exception {
        try {
            NameIDType nameIDType = this.convertToSAMLGenerator();
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<NameIDType> nameIDJaxbElement = factory.createNameID(nameIDType);
            Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(nameIDJaxbElement);
            Node encryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().encrypt(doc.getDocumentElement(), recepientPublicKey, algorithmURI);
            JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM((Element)encryptedDOMNode);
            EncryptedElementType jaxbEncryptedElement = factory.createEncryptedElementType();
            jaxbEncryptedElement.setEncryptedData((EncryptedDataType)jaxbElement.getValue());
            return new SAML2EncryptedNameIDJxbImpl(jaxbEncryptedElement);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to encrypt the SAML2 Name ID", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("Subject NameID\n");
        builder.append("  Format: ").append(this.format != null ? this.format : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified").append("\n");
        builder.append("  Value: ").append(this.name != null ? this.name : "").append("\n");
        builder.append("  Name Qualifier: ").append(this.nameQualifier != null ? this.nameQualifier : "").append("\n");
        builder.append("  SP Name Qualifier: ").append(this.spNameQualifier != null ? this.spNameQualifier : "").append("\n");
        builder.append("  SP Provided ID: ").append(this.spProvidedID != null ? this.spProvidedID : "").append("\n");
        return builder.toString();
    }
}

