/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedNewIDJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNewID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NewID;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmlenc.EncryptedDataType;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import java.security.Key;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2NewIDJxbImpl
implements SAML2NewID {
    private String newID;

    public SAML2NewIDJxbImpl(String newID) {
        this.newID = newID;
    }

    @Override
    public String convertToSAMLGenerator() {
        return this.newID;
    }

    @Override
    public SAML2EncryptedNewID encrypt(Key recepientPublicKey, String algorithmURI) throws SAML2Exception {
        try {
            String newIDType = this.convertToSAMLGenerator();
            com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory();
            JAXBElement<String> nameIDJaxbElement = factory.createNewID(newIDType);
            Document doc = SAML2JAXBUtils.marshalAssertionTokenToDOM(nameIDJaxbElement);
            Node encryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().encrypt(doc.getDocumentElement(), recepientPublicKey, algorithmURI);
            JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM((Element)encryptedDOMNode);
            EncryptedElementType jaxbEncryptedElement = new ObjectFactory().createEncryptedElementType();
            jaxbEncryptedElement.setEncryptedData((EncryptedDataType)jaxbElement.getValue());
            return new SAML2EncryptedNewIDJxbImpl(jaxbEncryptedElement);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to encrypt the SAML2 New ID", e);
        }
    }

    @Override
    public String getNewID() {
        return this.newID;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("SAML2NewID: value=").append(this.newID).append(";");
        return builder.toString();
    }
}

