/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2ProxyRestriction;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.assertion.ProxyRestrictionType;
import java.math.BigInteger;
import java.util.List;

public class SAML2ProxyRestrictionJxbImpl
implements SAML2ProxyRestriction {
    private List<String> audience;
    private Integer count;

    public SAML2ProxyRestrictionJxbImpl() throws SAML2Exception {
    }

    public SAML2ProxyRestrictionJxbImpl(ProxyRestrictionType proxyRestriction) throws SAML2Exception {
        if (proxyRestriction == null) {
            throw new SAML2Exception("The proxyRestriction cannot be null.");
        }
        this.audience = proxyRestriction.getAudience();
        BigInteger i = proxyRestriction.getCount();
        if (i != null) {
            this.count = i.intValue();
        }
    }

    @Override
    public ProxyRestrictionType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        ProxyRestrictionType proxyRestriction = factory.createProxyRestrictionType();
        if (this.audience != null && !this.audience.isEmpty()) {
            proxyRestriction.getAudience().addAll(this.audience);
        }
        if (this.count != null && this.count > -1) {
            BigInteger i = BigInteger.valueOf(this.count.intValue());
            proxyRestriction.setCount(i);
        }
        return proxyRestriction;
    }

    @Override
    public List<String> getAudience() {
        return this.audience;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    @Override
    public void setCount(Integer count) {
        this.count = count;
    }
}

