/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2IDPListJxbImpl;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPList;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Scoping;
import com.sap.security.saml2.lib.jaxb.protocol.IDPListType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.protocol.ScopingType;
import java.math.BigInteger;
import java.util.List;

public class SAML2ScopingJxbImpl
implements SAML2Scoping {
    private SAML2IDPList idpList;
    private Integer proxyCount;
    private List<String> requesterIDs;

    public SAML2ScopingJxbImpl() {
    }

    public SAML2ScopingJxbImpl(ScopingType jaxbScoping) {
        List<String> jaxbRequesterIDs;
        BigInteger i;
        IDPListType jaxbIDPList = jaxbScoping.getIDPList();
        if (jaxbIDPList != null) {
            this.idpList = new SAML2IDPListJxbImpl(jaxbIDPList);
        }
        if ((i = jaxbScoping.getProxyCount()) != null) {
            this.proxyCount = i.intValue();
        }
        if ((jaxbRequesterIDs = jaxbScoping.getRequesterID()) != null && jaxbRequesterIDs.size() > 0) {
            this.requesterIDs = jaxbRequesterIDs;
        }
    }

    @Override
    public SAML2IDPList getIDPList() {
        return this.idpList;
    }

    @Override
    public Integer getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public List<String> getRequesterIDs() {
        return this.requesterIDs;
    }

    @Override
    public void setIDPList(SAML2IDPList idpList) {
        this.idpList = idpList;
    }

    @Override
    public void setProxyCount(Integer proxyCount) {
        this.proxyCount = proxyCount;
    }

    @Override
    public void setRequesterIDs(List<String> requesterURIs) {
        this.requesterIDs = requesterURIs;
    }

    @Override
    public ScopingType convertToSAMLGenerator() {
        ObjectFactory factory = new ObjectFactory();
        ScopingType result = factory.createScopingType();
        if (this.idpList != null) {
            result.setIDPList((IDPListType)this.idpList.convertToSAMLGenerator());
        }
        if (this.proxyCount != null && this.proxyCount > -1) {
            BigInteger i = BigInteger.valueOf(this.proxyCount.intValue());
            result.setProxyCount(i);
        }
        if (this.requesterIDs != null) {
            result.getRequesterID().addAll(this.requesterIDs);
        }
        return result;
    }
}

