/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmationData;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectConfirmationDataType;
import com.sap.tc.logging.Location;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;

public class SAML2SubjectConfirmationDataJxbImpl
implements SAML2SubjectConfirmationData {
    private String address;
    private String inResponseTo;
    private Date notBefore;
    private Date notOnOrAfter;
    private String recipient;
    private static final Location LOCATION = Location.getLocation(SAML2SubjectConfirmationDataJxbImpl.class);

    public SAML2SubjectConfirmationDataJxbImpl() {
    }

    public SAML2SubjectConfirmationDataJxbImpl(SubjectConfirmationDataType subjectConfirmationData) throws SAML2Exception {
        if (subjectConfirmationData == null) {
            throw new SAML2Exception("The SubjectConfirmationData cannot be null.");
        }
        this.address = subjectConfirmationData.getAddress();
        this.inResponseTo = subjectConfirmationData.getInResponseTo();
        this.notBefore = SAML2Utils.convertXMLGregorianCalendarToDate(subjectConfirmationData.getNotBefore());
        this.notOnOrAfter = SAML2Utils.convertXMLGregorianCalendarToDate(subjectConfirmationData.getNotOnOrAfter());
        this.recipient = subjectConfirmationData.getRecipient();
    }

    public SubjectConfirmationDataType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        SubjectConfirmationDataType subjConfData = factory.createSubjectConfirmationDataType();
        return this.fillSubjectConfirmationData(subjConfData);
    }

    protected SubjectConfirmationDataType fillSubjectConfirmationData(SubjectConfirmationDataType subjConfData) throws SAML2Exception {
        try {
            subjConfData.setAddress(this.address);
            subjConfData.setInResponseTo(this.inResponseTo);
            XMLGregorianCalendar notBeforeGregorian = SAML2Utils.convertDateToXMLGregorianCalendar(this.notBefore);
            subjConfData.setNotBefore(notBeforeGregorian);
            XMLGregorianCalendar notAfterGregorian = SAML2Utils.convertDateToXMLGregorianCalendar(this.notOnOrAfter);
            subjConfData.setNotOnOrAfter(notAfterGregorian);
            subjConfData.setRecipient(this.recipient);
            return subjConfData;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to set data", e);
        }
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getInResponseTo() {
        return this.inResponseTo;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    @Override
    public String getRecipient() {
        return this.recipient;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void setInResponseTo(String inResponseTo) {
        this.inResponseTo = inResponseTo;
    }

    @Override
    public void setNotBefore(Date date) {
        this.notBefore = date;
    }

    @Override
    public void setNotOnOrAfter(Date date) {
        this.notOnOrAfter = date;
    }

    @Override
    public void setRecipient(String anyURI) {
        this.recipient = anyURI;
    }
}

