/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.assertions;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedNameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2KeyInfoConfirmationDataJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SubjectConfirmationDataJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmationData;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.KeyInfoConfirmationDataType;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.assertion.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectConfirmationDataType;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectConfirmationType;
import com.sap.tc.logging.Location;
import java.util.Date;

public class SAML2SubjectConfirmationJxbImpl
implements SAML2SubjectConfirmation {
    private static final Location LOCATION = Location.getLocation(SAML2SubjectConfirmationJxbImpl.class);
    private String method;
    private SAML2NameID nameId;
    private SAML2EncryptedNameID encryptedNameId;
    private SAML2SubjectConfirmationData subjectConfirmationData;

    public SAML2SubjectConfirmationJxbImpl(String method) {
        this.method = method;
    }

    public SAML2SubjectConfirmationJxbImpl(SubjectConfirmationType subjConfirmation) throws SAML2Exception {
        SubjectConfirmationDataType confData;
        EncryptedElementType enType;
        if (subjConfirmation == null) {
            throw new SAML2Exception("The SubjectConfirmation cannot be null.");
        }
        this.method = subjConfirmation.getMethod();
        NameIDType nameId = subjConfirmation.getNameID();
        if (nameId != null) {
            this.nameId = new SAML2NameIDJxbImpl(nameId);
        }
        if ((enType = subjConfirmation.getEncryptedID()) != null) {
            this.encryptedNameId = new SAML2EncryptedNameIDJxbImpl(enType);
        }
        if ((confData = subjConfirmation.getSubjectConfirmationData()) instanceof KeyInfoConfirmationDataType) {
            this.subjectConfirmationData = new SAML2KeyInfoConfirmationDataJxbImpl((KeyInfoConfirmationDataType)confData);
        } else if (confData != null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl(confData);
        }
    }

    @Override
    public SubjectConfirmationType convertToSAMLGenerator() throws SAML2Exception {
        ObjectFactory factory = new ObjectFactory();
        SubjectConfirmationType subjConf = factory.createSubjectConfirmationType();
        subjConf.setMethod(this.method);
        if (this.nameId != null) {
            subjConf.setNameID(this.nameId.convertToSAMLGenerator());
        }
        if (this.encryptedNameId != null) {
            subjConf.setEncryptedID(((SAML2EncryptedNameIDJxbImpl)this.encryptedNameId).convertToSAMLGenerator());
        }
        if (this.subjectConfirmationData != null) {
            subjConf.setSubjectConfirmationData(((SAML2SubjectConfirmationDataJxbImpl)this.subjectConfirmationData).convertToSAMLGenerator());
        }
        return subjConf;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public SAML2NameID getNameID() {
        return this.nameId;
    }

    @Override
    public SAML2EncryptedNameID getEncryptedNameID() {
        return this.encryptedNameId;
    }

    @Override
    public SAML2SubjectConfirmationData getSubjectConfirmationData() {
        return this.subjectConfirmationData;
    }

    @Override
    public void setSubjectConfirmationData(SAML2SubjectConfirmationData confirmationData) {
        this.subjectConfirmationData = confirmationData;
    }

    @Override
    public String getSubjectConfDataAddress() {
        if (this.subjectConfirmationData != null) {
            return this.subjectConfirmationData.getAddress();
        }
        return null;
    }

    @Override
    public String getSubjectConfDataInResponseTo() {
        if (this.subjectConfirmationData != null) {
            return this.subjectConfirmationData.getInResponseTo();
        }
        return null;
    }

    @Override
    public Date getSubjectConfDataNotBefore() {
        if (this.subjectConfirmationData != null) {
            return this.subjectConfirmationData.getNotBefore();
        }
        return null;
    }

    @Override
    public Date getSubjectConfDataNotOnOrAfter() {
        if (this.subjectConfirmationData != null) {
            return this.subjectConfirmationData.getNotOnOrAfter();
        }
        return null;
    }

    @Override
    public String getSubjectConfDataRecipient() {
        if (this.subjectConfirmationData != null) {
            return this.subjectConfirmationData.getRecipient();
        }
        return null;
    }

    @Override
    public void setNameID(SAML2NameID nameId) {
        if (nameId != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("The encrypted nameID: " + this.encryptedNameId + " will be replaced by the plain nameId: " + nameId);
            }
            this.encryptedNameId = null;
            this.nameId = nameId;
        }
    }

    @Override
    public void setEncryptedNameID(SAML2EncryptedNameID encryptedNameId) {
        if (encryptedNameId != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("The plain nameID: " + this.nameId + " will be replaced by the encrypted nameId: " + encryptedNameId);
            }
            this.nameId = null;
            this.encryptedNameId = encryptedNameId;
        }
    }

    @Override
    public void setSubjectConfDataAddress(String address) {
        if (this.subjectConfirmationData == null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl();
        }
        this.subjectConfirmationData.setAddress(address);
    }

    @Override
    public void setSubjectConfDataInResponseTo(String inResponseTo) {
        if (this.subjectConfirmationData == null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl();
        }
        this.subjectConfirmationData.setInResponseTo(inResponseTo);
    }

    @Override
    public void setSubjectConfDataNotBefore(Date date) {
        if (this.subjectConfirmationData == null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl();
        }
        this.subjectConfirmationData.setNotBefore(date);
    }

    @Override
    public void setSubjectConfDataNotOnOrAfter(Date date) {
        if (this.subjectConfirmationData == null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl();
        }
        this.subjectConfirmationData.setNotOnOrAfter(date);
    }

    @Override
    public void setSubjectConfDataRecipient(String anyURI) {
        if (this.subjectConfirmationData == null) {
            this.subjectConfirmationData = new SAML2SubjectConfirmationDataJxbImpl();
        }
        this.subjectConfirmationData.setRecipient(anyURI);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        if (this.subjectConfirmationData != null) {
            builder.append("  Recipient: ").append(this.subjectConfirmationData.getRecipient() != null ? this.subjectConfirmationData.getRecipient() : "").append("\n");
            builder.append("  In Response To: ").append(this.subjectConfirmationData.getInResponseTo() != null ? this.subjectConfirmationData.getInResponseTo() : "").append("\n");
        }
        builder.append("  Subject Confirmation Method: ").append(this.method != null ? this.method : "").append("\n");
        return builder.toString();
    }
}

