/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.attributes;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class AttributeValuePair {
    private static Location LOCATION = Location.getLocation(AttributeValuePair.class);
    private String name;
    private String format;
    private boolean isEncrypted;
    private List<Object> values = new ArrayList<Object>();
    private List<String> valuesAsStrings = new ArrayList<String>();

    public AttributeValuePair(String name, List<Object> value) throws SAML2Exception {
        if (name == null || name.length() < 1) {
            throw new SAML2Exception("Invalid name: " + name);
        }
        this.name = name;
        if (value != null && value.size() > 0) {
            for (Object object : value) {
                this.values.add(object);
                this.valuesAsStrings.add(this.convertObjectToString(object));
            }
        }
    }

    public AttributeValuePair(String name, List<Object> value, String format, boolean isEncrypted) throws SAML2Exception {
        this(name, value);
        this.isEncrypted = isEncrypted;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public List<String> getValuesAsStrings() {
        return Collections.unmodifiableList(this.valuesAsStrings);
    }

    public void addValues(List<Object> values) {
        if (values != null) {
            for (Object object : values) {
                this.values.add(object);
                this.valuesAsStrings.add(this.convertObjectToString(object));
            }
        }
    }

    private final String convertObjectToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Element) {
            Element element = (Element)o;
            if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(element.getNamespaceURI()) && "AttributeValue".equals(element.getLocalName())) {
                String childText = SAML2Utils.getElementValueAsChildText(element);
                if (childText != null) {
                    return childText;
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Received <AttributeValue> is empty or it does not contain only a Text child. XML: {0}", new Object[]{SAML2Utils.transformDOMForTrace(element)});
                }
                return null;
            }
            if (LOCATION.beDebug() && LOCATION.beDebug()) {
                LOCATION.debugT("Received XML content in the place for <AttributeValue> does not correspond to the saml assertion schema. XML: {0}", new Object[]{SAML2Utils.transformDOMForTrace(element)});
            }
            return null;
        }
        return o.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("  Name: ").append(this.name != null ? this.name : "").append("\n");
        builder.append("  Format: ").append(this.format != null ? this.format : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified").append("\n");
        builder.append("  Values: ").append(this.valuesAsStrings != null ? this.valuesAsStrings : "").append("\n");
        builder.append("  Encrypted: ").append(this.isEncrypted).append("\n");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        result = 31 * result + (this.valuesAsStrings == null ? 0 : this.valuesAsStrings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeValuePair other = (AttributeValuePair)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!this.myEquals(this.values, other.values)) {
            return false;
        }
        return this.myEquals(this.valuesAsStrings, other.valuesAsStrings);
    }

    private boolean myEquals(List<?> l1, List<?> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        return l1.containsAll(l2) && l2.containsAll(l1);
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getFormat() {
        return this.format;
    }
}

